@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AudioOverlayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of an audio overlay.
 * @property audioGainLevel The gain level of audio in the overlay. The value should be in the range [0, 1&#46;0]. The default is 1.0.
 * @property end The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
 * @property fadeInDuration The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
 * @property fadeOutDuration The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
 * @property inputLabel The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AudioOverlay'.
 * @property start The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
 */
public data class AudioOverlayArgs(
    public val audioGainLevel: Output<Double>? = null,
    public val end: Output<String>? = null,
    public val fadeInDuration: Output<String>? = null,
    public val fadeOutDuration: Output<String>? = null,
    public val inputLabel: Output<String>,
    public val odataType: Output<String>,
    public val start: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AudioOverlayArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AudioOverlayArgs =
        com.pulumi.azurenative.media.inputs.AudioOverlayArgs.builder()
            .audioGainLevel(audioGainLevel?.applyValue({ args0 -> args0 }))
            .end(end?.applyValue({ args0 -> args0 }))
            .fadeInDuration(fadeInDuration?.applyValue({ args0 -> args0 }))
            .fadeOutDuration(fadeOutDuration?.applyValue({ args0 -> args0 }))
            .inputLabel(inputLabel.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AudioOverlayArgs].
 */
@PulumiTagMarker
public class AudioOverlayArgsBuilder internal constructor() {
    private var audioGainLevel: Output<Double>? = null

    private var end: Output<String>? = null

    private var fadeInDuration: Output<String>? = null

    private var fadeOutDuration: Output<String>? = null

    private var inputLabel: Output<String>? = null

    private var odataType: Output<String>? = null

    private var start: Output<String>? = null

    /**
     * @param value The gain level of audio in the overlay. The value should be in the range [0, 1&#46;0]. The default is 1.0.
     */
    @JvmName("bvsqyvfgdxwsgfrl")
    public suspend fun audioGainLevel(`value`: Output<Double>) {
        this.audioGainLevel = value
    }

    /**
     * @param value The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
     */
    @JvmName("udhgrwfmyreomdia")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
     */
    @JvmName("fsjwojduyfvreoms")
    public suspend fun fadeInDuration(`value`: Output<String>) {
        this.fadeInDuration = value
    }

    /**
     * @param value The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
     */
    @JvmName("secejfxkwhjlrang")
    public suspend fun fadeOutDuration(`value`: Output<String>) {
        this.fadeOutDuration = value
    }

    /**
     * @param value The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
     */
    @JvmName("iahtjxkevafjejfp")
    public suspend fun inputLabel(`value`: Output<String>) {
        this.inputLabel = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AudioOverlay'.
     */
    @JvmName("jqmlxvhqnlekjepe")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
     */
    @JvmName("yohkrqfsruamxatq")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value The gain level of audio in the overlay. The value should be in the range [0, 1&#46;0]. The default is 1.0.
     */
    @JvmName("ckvbposxpmdghcfr")
    public suspend fun audioGainLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioGainLevel = mapped
    }

    /**
     * @param value The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
     */
    @JvmName("jdoipxyntoxnaoxc")
    public suspend fun end(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
     */
    @JvmName("awsefxrhravkoivj")
    public suspend fun fadeInDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fadeInDuration = mapped
    }

    /**
     * @param value The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
     */
    @JvmName("xwnjakabnlmlobyd")
    public suspend fun fadeOutDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fadeOutDuration = mapped
    }

    /**
     * @param value The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
     */
    @JvmName("mlemierbkewrrhrv")
    public suspend fun inputLabel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputLabel = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AudioOverlay'.
     */
    @JvmName("eppelivgbqwnykxs")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
     */
    @JvmName("hcqwwqvbkcjleqkx")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): AudioOverlayArgs = AudioOverlayArgs(
        audioGainLevel = audioGainLevel,
        end = end,
        fadeInDuration = fadeInDuration,
        fadeOutDuration = fadeOutDuration,
        inputLabel = inputLabel ?: throw PulumiNullFieldException("inputLabel"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        start = start,
    )
}
