@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
 * @property playReady PlayReady configurations
 * @property widevine Widevine configurations
 */
public data class CencDrmConfigurationArgs(
    public val playReady: Output<StreamingPolicyPlayReadyConfigurationArgs>? = null,
    public val widevine: Output<StreamingPolicyWidevineConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs =
        com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs.builder()
            .playReady(playReady?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .widevine(widevine?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CencDrmConfigurationArgs].
 */
@PulumiTagMarker
public class CencDrmConfigurationArgsBuilder internal constructor() {
    private var playReady: Output<StreamingPolicyPlayReadyConfigurationArgs>? = null

    private var widevine: Output<StreamingPolicyWidevineConfigurationArgs>? = null

    /**
     * @param value PlayReady configurations
     */
    @JvmName("hfxawdpjhicnntyx")
    public suspend fun playReady(`value`: Output<StreamingPolicyPlayReadyConfigurationArgs>) {
        this.playReady = value
    }

    /**
     * @param value Widevine configurations
     */
    @JvmName("finovejnqyyhonkg")
    public suspend fun widevine(`value`: Output<StreamingPolicyWidevineConfigurationArgs>) {
        this.widevine = value
    }

    /**
     * @param value PlayReady configurations
     */
    @JvmName("kudiprcjncfvvhui")
    public suspend fun playReady(`value`: StreamingPolicyPlayReadyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playReady = mapped
    }

    /**
     * @param argument PlayReady configurations
     */
    @JvmName("mpgyouklsgqdumxj")
    public suspend
    fun playReady(argument: suspend StreamingPolicyPlayReadyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyPlayReadyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.playReady = mapped
    }

    /**
     * @param value Widevine configurations
     */
    @JvmName("dyxcgfpnnrorcjwk")
    public suspend fun widevine(`value`: StreamingPolicyWidevineConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.widevine = mapped
    }

    /**
     * @param argument Widevine configurations
     */
    @JvmName("makldjpclxtvfcmk")
    public suspend
    fun widevine(argument: suspend StreamingPolicyWidevineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyWidevineConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.widevine = mapped
    }

    internal fun build(): CencDrmConfigurationArgs = CencDrmConfigurationArgs(
        playReady = playReady,
        widevine = widevine,
    )
}
