@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property playbackDurationSeconds Playback duration
 * @property storageDurationSeconds Storage duration
 */
public data class ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs(
    public val playbackDurationSeconds: Output<Double>,
    public val storageDurationSeconds: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs.builder()
            .playbackDurationSeconds(playbackDurationSeconds.applyValue({ args0 -> args0 }))
            .storageDurationSeconds(storageDurationSeconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyFairPlayOfflineRentalConfigurationArgsBuilder internal constructor() {
    private var playbackDurationSeconds: Output<Double>? = null

    private var storageDurationSeconds: Output<Double>? = null

    /**
     * @param value Playback duration
     */
    @JvmName("tefwioohxepkwkrk")
    public suspend fun playbackDurationSeconds(`value`: Output<Double>) {
        this.playbackDurationSeconds = value
    }

    /**
     * @param value Storage duration
     */
    @JvmName("wrbjlpundwhghihs")
    public suspend fun storageDurationSeconds(`value`: Output<Double>) {
        this.storageDurationSeconds = value
    }

    /**
     * @param value Playback duration
     */
    @JvmName("vxmrujlqkrhjfmgn")
    public suspend fun playbackDurationSeconds(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.playbackDurationSeconds = mapped
    }

    /**
     * @param value Storage duration
     */
    @JvmName("ntqoivjuslfcdnoy")
    public suspend fun storageDurationSeconds(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageDurationSeconds = mapped
    }

    internal fun build(): ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs =
        ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs(
            playbackDurationSeconds = playbackDurationSeconds ?: throw
                PulumiNullFieldException("playbackDurationSeconds"),
            storageDurationSeconds = storageDurationSeconds ?: throw
                PulumiNullFieldException("storageDurationSeconds"),
        )
}
