@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyOpenRestrictionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an open restriction. License or key will be delivered on every request.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
 */
public data class ContentKeyPolicyOpenRestrictionArgs(
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyOpenRestrictionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyOpenRestrictionArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyOpenRestrictionArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyOpenRestrictionArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyOpenRestrictionArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
     */
    @JvmName("iyuuntktfgstjjvy")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
     */
    @JvmName("qpobxltalpumjraq")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ContentKeyPolicyOpenRestrictionArgs = ContentKeyPolicyOpenRestrictionArgs(
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
