@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyX509CertificateTokenKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies a certificate for token validation.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
 * @property rawBody The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
 */
public data class ContentKeyPolicyX509CertificateTokenKeyArgs(
    public val odataType: Output<String>,
    public val rawBody: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyX509CertificateTokenKeyArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyX509CertificateTokenKeyArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyX509CertificateTokenKeyArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .rawBody(rawBody.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyX509CertificateTokenKeyArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyX509CertificateTokenKeyArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    private var rawBody: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
     */
    @JvmName("osluigkekfcywfbq")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
     */
    @JvmName("wytknogytuyajqly")
    public suspend fun rawBody(`value`: Output<String>) {
        this.rawBody = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
     */
    @JvmName("yocindxwchlfgrfi")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
     */
    @JvmName("eyyvqyqwtbrevjfd")
    public suspend fun rawBody(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rawBody = mapped
    }

    internal fun build(): ContentKeyPolicyX509CertificateTokenKeyArgs =
        ContentKeyPolicyX509CertificateTokenKeyArgs(
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
            rawBody = rawBody ?: throw PulumiNullFieldException("rawBody"),
        )
}
