@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.CopyAudioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A codec flag, which tells the encoder to copy the input audio bitstream.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.CopyAudio'.
 */
public data class CopyAudioArgs(
    public val label: Output<String>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.CopyAudioArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.CopyAudioArgs =
        com.pulumi.azurenative.media.inputs.CopyAudioArgs.builder()
            .label(label?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CopyAudioArgs].
 */
@PulumiTagMarker
public class CopyAudioArgsBuilder internal constructor() {
    private var label: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("euabdxcaxnkeckju")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.CopyAudio'.
     */
    @JvmName("clxdmqgoufsnhchv")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("vmdibfbxpqmwwapp")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.CopyAudio'.
     */
    @JvmName("bbyfvvjnswivtnww")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): CopyAudioArgs = CopyAudioArgs(
        label = label,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
