@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.CopyVideoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.CopyVideo'.
 */
public data class CopyVideoArgs(
    public val label: Output<String>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.CopyVideoArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.CopyVideoArgs =
        com.pulumi.azurenative.media.inputs.CopyVideoArgs.builder()
            .label(label?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CopyVideoArgs].
 */
@PulumiTagMarker
public class CopyVideoArgsBuilder internal constructor() {
    private var label: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("fwwmxvglhdglggug")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.CopyVideo'.
     */
    @JvmName("umpqbrcvscvkgtgv")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("luhogagshcaonwph")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.CopyVideo'.
     */
    @JvmName("jswljbwcnveltwit")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): CopyVideoArgs = CopyVideoArgs(
        label = label,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
