@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.DefaultKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class to specify properties of default content key for each encryption scheme
 * @property label Label can be used to specify Content Key when creating a Streaming Locator
 * @property policyName Policy used by Default Key
 */
public data class DefaultKeyArgs(
    public val label: Output<String>? = null,
    public val policyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.DefaultKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.DefaultKeyArgs =
        com.pulumi.azurenative.media.inputs.DefaultKeyArgs.builder()
            .label(label?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultKeyArgs].
 */
@PulumiTagMarker
public class DefaultKeyArgsBuilder internal constructor() {
    private var label: Output<String>? = null

    private var policyName: Output<String>? = null

    /**
     * @param value Label can be used to specify Content Key when creating a Streaming Locator
     */
    @JvmName("cyqerqpebvgajaol")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Policy used by Default Key
     */
    @JvmName("ujjjcohgrnxiuawn")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Label can be used to specify Content Key when creating a Streaming Locator
     */
    @JvmName("yatjquhxtkudtxml")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Policy used by Default Key
     */
    @JvmName("mqkqamxdfgdjhtob")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    internal fun build(): DefaultKeyArgs = DefaultKeyArgs(
        label = label,
        policyName = policyName,
    )
}
