@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FadeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of a Fade effect applied to the input media.
 * @property duration The Duration of the fade effect in the video. The value can be in ISO 8601 format (For example, PT05S to fade In/Out a color during 5 seconds), or a frame count (For example, 10 to fade 10 frames from the start time), or a relative value to stream duration (For example, 10% to fade 10% of stream duration)
 * @property fadeColor The Color for the fade In/Out. it can be on the CSS Level1 colors https://developer.mozilla.org/en-US/docs/Web/CSS/color_value/color_keywords or an RGB/hex value: e.g: rgb(255,0,0), 0xFF0000 or #FF0000
 * @property start The position in the input video from where to start fade. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Default is 0
 */
public data class FadeArgs(
    public val duration: Output<String>,
    public val fadeColor: Output<String>,
    public val start: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FadeArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FadeArgs =
        com.pulumi.azurenative.media.inputs.FadeArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .fadeColor(fadeColor.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FadeArgs].
 */
@PulumiTagMarker
public class FadeArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var fadeColor: Output<String>? = null

    private var start: Output<String>? = null

    /**
     * @param value The Duration of the fade effect in the video. The value can be in ISO 8601 format (For example, PT05S to fade In/Out a color during 5 seconds), or a frame count (For example, 10 to fade 10 frames from the start time), or a relative value to stream duration (For example, 10% to fade 10% of stream duration)
     */
    @JvmName("anegbnigslemklvu")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The Color for the fade In/Out. it can be on the CSS Level1 colors https://developer.mozilla.org/en-US/docs/Web/CSS/color_value/color_keywords or an RGB/hex value: e.g: rgb(255,0,0), 0xFF0000 or #FF0000
     */
    @JvmName("qvhbejrlsaxkyjob")
    public suspend fun fadeColor(`value`: Output<String>) {
        this.fadeColor = value
    }

    /**
     * @param value The position in the input video from where to start fade. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Default is 0
     */
    @JvmName("bnpwmgbjmnbgvwsa")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value The Duration of the fade effect in the video. The value can be in ISO 8601 format (For example, PT05S to fade In/Out a color during 5 seconds), or a frame count (For example, 10 to fade 10 frames from the start time), or a relative value to stream duration (For example, 10% to fade 10% of stream duration)
     */
    @JvmName("vsuyeoimfhmgfdrb")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The Color for the fade In/Out. it can be on the CSS Level1 colors https://developer.mozilla.org/en-US/docs/Web/CSS/color_value/color_keywords or an RGB/hex value: e.g: rgb(255,0,0), 0xFF0000 or #FF0000
     */
    @JvmName("vjdwsiarxutpusll")
    public suspend fun fadeColor(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fadeColor = mapped
    }

    /**
     * @param value The position in the input video from where to start fade. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Default is 0
     */
    @JvmName("vyxcoqwxcuixgxtf")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): FadeArgs = FadeArgs(
        duration = duration ?: throw PulumiNullFieldException("duration"),
        fadeColor = fadeColor ?: throw PulumiNullFieldException("fadeColor"),
        start = start,
    )
}
