@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetContentKeyPolicyPropertiesWithSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property contentKeyPolicyName The Content Key Policy name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetContentKeyPolicyPropertiesWithSecretsPlainArgs(
    public val accountName: String,
    public val contentKeyPolicyName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetContentKeyPolicyPropertiesWithSecretsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.GetContentKeyPolicyPropertiesWithSecretsPlainArgs =
        com.pulumi.azurenative.media.inputs.GetContentKeyPolicyPropertiesWithSecretsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .contentKeyPolicyName(contentKeyPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContentKeyPolicyPropertiesWithSecretsPlainArgs].
 */
@PulumiTagMarker
public class GetContentKeyPolicyPropertiesWithSecretsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var contentKeyPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("hlvllyyjonwmkdlt")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Content Key Policy name.
     */
    @JvmName("dhwvyeksdtemjcpw")
    public suspend fun contentKeyPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contentKeyPolicyName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("tannghseipdcukxj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetContentKeyPolicyPropertiesWithSecretsPlainArgs =
        GetContentKeyPolicyPropertiesWithSecretsPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            contentKeyPolicyName = contentKeyPolicyName ?: throw
                PulumiNullFieldException("contentKeyPolicyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
