@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.H264LayerArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.EntropyMode
import com.pulumi.azurenative.media.kotlin.enums.H264VideoProfile
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.
 * @property adaptiveBFrame Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
 * @property bFrames The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
 * @property bitrate The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
 * @property bufferWindow The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0&#46;1-100] seconds. The default is 5 seconds (for example, PT5S).
 * @property crf The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
 * @property entropyMode The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
 * @property frameRate The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
 * @property height The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
 * @property label The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
 * @property level We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
 * @property maxBitrate The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
 * @property profile We currently support Baseline, Main, High, High422, High444. Default is Auto.
 * @property referenceFrames The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
 * @property slices The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
 * @property width The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
 */
public data class H264LayerArgs(
    public val adaptiveBFrame: Output<Boolean>? = null,
    public val bFrames: Output<Int>? = null,
    public val bitrate: Output<Int>,
    public val bufferWindow: Output<String>? = null,
    public val crf: Output<Double>? = null,
    public val entropyMode: Output<Either<String, EntropyMode>>? = null,
    public val frameRate: Output<String>? = null,
    public val height: Output<String>? = null,
    public val label: Output<String>? = null,
    public val level: Output<String>? = null,
    public val maxBitrate: Output<Int>? = null,
    public val profile: Output<Either<String, H264VideoProfile>>? = null,
    public val referenceFrames: Output<Int>? = null,
    public val slices: Output<Int>? = null,
    public val width: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.H264LayerArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.H264LayerArgs =
        com.pulumi.azurenative.media.inputs.H264LayerArgs.builder()
            .adaptiveBFrame(adaptiveBFrame?.applyValue({ args0 -> args0 }))
            .bFrames(bFrames?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate.applyValue({ args0 -> args0 }))
            .bufferWindow(bufferWindow?.applyValue({ args0 -> args0 }))
            .crf(crf?.applyValue({ args0 -> args0 }))
            .entropyMode(
                entropyMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .frameRate(frameRate?.applyValue({ args0 -> args0 }))
            .height(height?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .maxBitrate(maxBitrate?.applyValue({ args0 -> args0 }))
            .profile(
                profile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .referenceFrames(referenceFrames?.applyValue({ args0 -> args0 }))
            .slices(slices?.applyValue({ args0 -> args0 }))
            .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [H264LayerArgs].
 */
@PulumiTagMarker
public class H264LayerArgsBuilder internal constructor() {
    private var adaptiveBFrame: Output<Boolean>? = null

    private var bFrames: Output<Int>? = null

    private var bitrate: Output<Int>? = null

    private var bufferWindow: Output<String>? = null

    private var crf: Output<Double>? = null

    private var entropyMode: Output<Either<String, EntropyMode>>? = null

    private var frameRate: Output<String>? = null

    private var height: Output<String>? = null

    private var label: Output<String>? = null

    private var level: Output<String>? = null

    private var maxBitrate: Output<Int>? = null

    private var profile: Output<Either<String, H264VideoProfile>>? = null

    private var referenceFrames: Output<Int>? = null

    private var slices: Output<Int>? = null

    private var width: Output<String>? = null

    /**
     * @param value Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
     */
    @JvmName("tupgkshhmdgctnth")
    public suspend fun adaptiveBFrame(`value`: Output<Boolean>) {
        this.adaptiveBFrame = value
    }

    /**
     * @param value The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
     */
    @JvmName("ahqqkluwbcnxbvhc")
    public suspend fun bFrames(`value`: Output<Int>) {
        this.bFrames = value
    }

    /**
     * @param value The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
     */
    @JvmName("dibmtgyuiribcnwj")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0&#46;1-100] seconds. The default is 5 seconds (for example, PT5S).
     */
    @JvmName("bldhgfqsbxnixpha")
    public suspend fun bufferWindow(`value`: Output<String>) {
        this.bufferWindow = value
    }

    /**
     * @param value The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
     */
    @JvmName("oxbrvpgirwmlbjaf")
    public suspend fun crf(`value`: Output<Double>) {
        this.crf = value
    }

    /**
     * @param value The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
     */
    @JvmName("ulnisvqhhxgjvlif")
    public suspend fun entropyMode(`value`: Output<Either<String, EntropyMode>>) {
        this.entropyMode = value
    }

    /**
     * @param value The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
     */
    @JvmName("qbcwlpwogaqtlkbf")
    public suspend fun frameRate(`value`: Output<String>) {
        this.frameRate = value
    }

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("ttfxdcusveahhubr")
    public suspend fun height(`value`: Output<String>) {
        this.height = value
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("xqdnwebkmmajgwrr")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
     */
    @JvmName("ejgenjkwkhtwchdv")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
     */
    @JvmName("ihrttdmwaynqqkqe")
    public suspend fun maxBitrate(`value`: Output<Int>) {
        this.maxBitrate = value
    }

    /**
     * @param value We currently support Baseline, Main, High, High422, High444. Default is Auto.
     */
    @JvmName("jtpxaclkuywporkt")
    public suspend fun profile(`value`: Output<Either<String, H264VideoProfile>>) {
        this.profile = value
    }

    /**
     * @param value The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
     */
    @JvmName("ltrahlhhsltoeqnp")
    public suspend fun referenceFrames(`value`: Output<Int>) {
        this.referenceFrames = value
    }

    /**
     * @param value The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
     */
    @JvmName("nnofagpxtdrelvbl")
    public suspend fun slices(`value`: Output<Int>) {
        this.slices = value
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("xgofytlvvenflkth")
    public suspend fun width(`value`: Output<String>) {
        this.width = value
    }

    /**
     * @param value Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
     */
    @JvmName("xeytmbuojjkkttft")
    public suspend fun adaptiveBFrame(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adaptiveBFrame = mapped
    }

    /**
     * @param value The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
     */
    @JvmName("glouuiwalcfsosld")
    public suspend fun bFrames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bFrames = mapped
    }

    /**
     * @param value The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
     */
    @JvmName("irldflaoiqycyoqt")
    public suspend fun bitrate(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0&#46;1-100] seconds. The default is 5 seconds (for example, PT5S).
     */
    @JvmName("tyudthifufamdink")
    public suspend fun bufferWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferWindow = mapped
    }

    /**
     * @param value The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
     */
    @JvmName("mdemburrbmdgoddi")
    public suspend fun crf(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crf = mapped
    }

    /**
     * @param value The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
     */
    @JvmName("vnawhobnjglyxriq")
    public suspend fun entropyMode(`value`: Either<String, EntropyMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entropyMode = mapped
    }

    /**
     * @param value The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
     */
    @JvmName("hvtsxqbnfqtglmjn")
    public fun entropyMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EntropyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entropyMode = mapped
    }

    /**
     * @param value The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
     */
    @JvmName("rsxmvirugjprmxpc")
    public fun entropyMode(`value`: EntropyMode) {
        val toBeMapped = Either.ofRight<String, EntropyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entropyMode = mapped
    }

    /**
     * @param value The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
     */
    @JvmName("dxiajmqqwvapgkyp")
    public suspend fun frameRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameRate = mapped
    }

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("qwanoqkcfuxlnsth")
    public suspend fun height(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("edosmxhxumbkswhh")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
     */
    @JvmName("vrfwsbefsgeitsrd")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
     */
    @JvmName("lxqbwbaypmogsryv")
    public suspend fun maxBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBitrate = mapped
    }

    /**
     * @param value We currently support Baseline, Main, High, High422, High444. Default is Auto.
     */
    @JvmName("evaewethqjtculgp")
    public suspend fun profile(`value`: Either<String, H264VideoProfile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value We currently support Baseline, Main, High, High422, High444. Default is Auto.
     */
    @JvmName("ipanfwcgfpmgosii")
    public fun profile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, H264VideoProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value We currently support Baseline, Main, High, High422, High444. Default is Auto.
     */
    @JvmName("uctldsnuanorfhsh")
    public fun profile(`value`: H264VideoProfile) {
        val toBeMapped = Either.ofRight<String, H264VideoProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
     */
    @JvmName("xdlmtlaqonwptepo")
    public suspend fun referenceFrames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceFrames = mapped
    }

    /**
     * @param value The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
     */
    @JvmName("bkpjvkplichtqlfb")
    public suspend fun slices(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slices = mapped
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("ggbyjwptmomuvqob")
    public suspend fun width(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): H264LayerArgs = H264LayerArgs(
        adaptiveBFrame = adaptiveBFrame,
        bFrames = bFrames,
        bitrate = bitrate ?: throw PulumiNullFieldException("bitrate"),
        bufferWindow = bufferWindow,
        crf = crf,
        entropyMode = entropyMode,
        frameRate = frameRate,
        height = height,
        label = label,
        level = level,
        maxBitrate = maxBitrate,
        profile = profile,
        referenceFrames = referenceFrames,
        slices = slices,
        width = width,
    )
}
