@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.H265LayerArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.H265VideoProfile
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.265 video codec.
 * @property adaptiveBFrame Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
 * @property bFrames The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
 * @property bitrate The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
 * @property bufferWindow The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0&#46;1-100] seconds. The default is 5 seconds (for example, PT5S).
 * @property crf The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
 * @property frameRate The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
 * @property height The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
 * @property label The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
 * @property level We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
 * @property maxBitrate The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
 * @property profile We currently support Main. Default is Auto.
 * @property referenceFrames The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
 * @property slices The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
 * @property width The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
 */
public data class H265LayerArgs(
    public val adaptiveBFrame: Output<Boolean>? = null,
    public val bFrames: Output<Int>? = null,
    public val bitrate: Output<Int>,
    public val bufferWindow: Output<String>? = null,
    public val crf: Output<Double>? = null,
    public val frameRate: Output<String>? = null,
    public val height: Output<String>? = null,
    public val label: Output<String>? = null,
    public val level: Output<String>? = null,
    public val maxBitrate: Output<Int>? = null,
    public val profile: Output<Either<String, H265VideoProfile>>? = null,
    public val referenceFrames: Output<Int>? = null,
    public val slices: Output<Int>? = null,
    public val width: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.H265LayerArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.H265LayerArgs =
        com.pulumi.azurenative.media.inputs.H265LayerArgs.builder()
            .adaptiveBFrame(adaptiveBFrame?.applyValue({ args0 -> args0 }))
            .bFrames(bFrames?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate.applyValue({ args0 -> args0 }))
            .bufferWindow(bufferWindow?.applyValue({ args0 -> args0 }))
            .crf(crf?.applyValue({ args0 -> args0 }))
            .frameRate(frameRate?.applyValue({ args0 -> args0 }))
            .height(height?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .maxBitrate(maxBitrate?.applyValue({ args0 -> args0 }))
            .profile(
                profile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .referenceFrames(referenceFrames?.applyValue({ args0 -> args0 }))
            .slices(slices?.applyValue({ args0 -> args0 }))
            .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [H265LayerArgs].
 */
@PulumiTagMarker
public class H265LayerArgsBuilder internal constructor() {
    private var adaptiveBFrame: Output<Boolean>? = null

    private var bFrames: Output<Int>? = null

    private var bitrate: Output<Int>? = null

    private var bufferWindow: Output<String>? = null

    private var crf: Output<Double>? = null

    private var frameRate: Output<String>? = null

    private var height: Output<String>? = null

    private var label: Output<String>? = null

    private var level: Output<String>? = null

    private var maxBitrate: Output<Int>? = null

    private var profile: Output<Either<String, H265VideoProfile>>? = null

    private var referenceFrames: Output<Int>? = null

    private var slices: Output<Int>? = null

    private var width: Output<String>? = null

    /**
     * @param value Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
     */
    @JvmName("tavwfvcyugglheby")
    public suspend fun adaptiveBFrame(`value`: Output<Boolean>) {
        this.adaptiveBFrame = value
    }

    /**
     * @param value The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
     */
    @JvmName("eavrpxdwnyauydml")
    public suspend fun bFrames(`value`: Output<Int>) {
        this.bFrames = value
    }

    /**
     * @param value The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
     */
    @JvmName("cdlojrpjgwxpcntl")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0&#46;1-100] seconds. The default is 5 seconds (for example, PT5S).
     */
    @JvmName("vbikvksqgcxxyyth")
    public suspend fun bufferWindow(`value`: Output<String>) {
        this.bufferWindow = value
    }

    /**
     * @param value The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
     */
    @JvmName("iqjjkckvcpeypilm")
    public suspend fun crf(`value`: Output<Double>) {
        this.crf = value
    }

    /**
     * @param value The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
     */
    @JvmName("vpvgdqlxyholdubm")
    public suspend fun frameRate(`value`: Output<String>) {
        this.frameRate = value
    }

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("yjxdolmtpqoecofk")
    public suspend fun height(`value`: Output<String>) {
        this.height = value
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("ntjdnanvbivpwvgs")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
     */
    @JvmName("idcpqxivjrunlunx")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
     */
    @JvmName("fwfxbxnxauhionnb")
    public suspend fun maxBitrate(`value`: Output<Int>) {
        this.maxBitrate = value
    }

    /**
     * @param value We currently support Main. Default is Auto.
     */
    @JvmName("yfarktiswpjxppcp")
    public suspend fun profile(`value`: Output<Either<String, H265VideoProfile>>) {
        this.profile = value
    }

    /**
     * @param value The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
     */
    @JvmName("unjrvkwmvyiinoyu")
    public suspend fun referenceFrames(`value`: Output<Int>) {
        this.referenceFrames = value
    }

    /**
     * @param value The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
     */
    @JvmName("bjoccdvgxnfvyecg")
    public suspend fun slices(`value`: Output<Int>) {
        this.slices = value
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("sxkkisjbfdxphhjq")
    public suspend fun width(`value`: Output<String>) {
        this.width = value
    }

    /**
     * @param value Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
     */
    @JvmName("imjlnmmtbcmrqdbs")
    public suspend fun adaptiveBFrame(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adaptiveBFrame = mapped
    }

    /**
     * @param value The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
     */
    @JvmName("onhmojovhpgpusvj")
    public suspend fun bFrames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bFrames = mapped
    }

    /**
     * @param value The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
     */
    @JvmName("fohfcdrsxdvgopuk")
    public suspend fun bitrate(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0&#46;1-100] seconds. The default is 5 seconds (for example, PT5S).
     */
    @JvmName("rkneiypbopuvxckl")
    public suspend fun bufferWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferWindow = mapped
    }

    /**
     * @param value The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
     */
    @JvmName("affgtswkcmgtcvfe")
    public suspend fun crf(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crf = mapped
    }

    /**
     * @param value The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
     */
    @JvmName("qyslhevrdsewyvsu")
    public suspend fun frameRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameRate = mapped
    }

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("gwdistrohcwwoxtm")
    public suspend fun height(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("lshhkawudqbderug")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
     */
    @JvmName("wbalrvhdpdbnugvk")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
     */
    @JvmName("ifltloesfdphoaok")
    public suspend fun maxBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBitrate = mapped
    }

    /**
     * @param value We currently support Main. Default is Auto.
     */
    @JvmName("usoedyxdxitttpmh")
    public suspend fun profile(`value`: Either<String, H265VideoProfile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value We currently support Main. Default is Auto.
     */
    @JvmName("dqnprxbweoggsjdg")
    public fun profile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, H265VideoProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value We currently support Main. Default is Auto.
     */
    @JvmName("xddnlscmewgynqiu")
    public fun profile(`value`: H265VideoProfile) {
        val toBeMapped = Either.ofRight<String, H265VideoProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
     */
    @JvmName("hldxqtrbkvpygchy")
    public suspend fun referenceFrames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceFrames = mapped
    }

    /**
     * @param value The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
     */
    @JvmName("leayndiopdwttvdt")
    public suspend fun slices(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slices = mapped
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("itntdbjyrpdxrykd")
    public suspend fun width(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): H265LayerArgs = H265LayerArgs(
        adaptiveBFrame = adaptiveBFrame,
        bFrames = bFrames,
        bitrate = bitrate ?: throw PulumiNullFieldException("bitrate"),
        bufferWindow = bufferWindow,
        crf = crf,
        frameRate = frameRate,
        height = height,
        label = label,
        level = level,
        maxBitrate = maxBitrate,
        profile = profile,
        referenceFrames = referenceFrames,
        slices = slices,
        width = width,
    )
}
