@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyIdentifier The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
 */
public data class KeyVaultPropertiesArgs(
    public val keyIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.media.inputs.KeyVaultPropertiesArgs.builder()
            .keyIdentifier(keyIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyIdentifier: Output<String>? = null

    /**
     * @param value The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
     */
    @JvmName("ieqypxhnqybgtujl")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
     */
    @JvmName("rjyxydpjdvbaedwy")
    public suspend fun keyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyIdentifier = keyIdentifier,
    )
}
