@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ListStreamingLocatorContentKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property streamingLocatorName The Streaming Locator name.
 */
public data class ListStreamingLocatorContentKeysPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val streamingLocatorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ListStreamingLocatorContentKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ListStreamingLocatorContentKeysPlainArgs =
        com.pulumi.azurenative.media.inputs.ListStreamingLocatorContentKeysPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .streamingLocatorName(streamingLocatorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListStreamingLocatorContentKeysPlainArgs].
 */
@PulumiTagMarker
public class ListStreamingLocatorContentKeysPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var streamingLocatorName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("yhmkrlbskypoiasv")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("yeyssfpjhhdeswip")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Streaming Locator name.
     */
    @JvmName("msljgvsjlfaeewrb")
    public suspend fun streamingLocatorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.streamingLocatorName = mapped
    }

    internal fun build(): ListStreamingLocatorContentKeysPlainArgs =
        ListStreamingLocatorContentKeysPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            streamingLocatorName = streamingLocatorName ?: throw
                PulumiNullFieldException("streamingLocatorName"),
        )
}
