@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventEncodingArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.LiveEventEncodingType
import com.pulumi.azurenative.media.kotlin.enums.StretchMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the live event type and optional encoding settings for encoding live events.
 * @property encodingType Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
 * @property keyFrameInterval Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
 * @property presetName The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
 * @property stretchMode Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
 */
public data class LiveEventEncodingArgs(
    public val encodingType: Output<Either<String, LiveEventEncodingType>>? = null,
    public val keyFrameInterval: Output<String>? = null,
    public val presetName: Output<String>? = null,
    public val stretchMode: Output<Either<String, StretchMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventEncodingArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventEncodingArgs =
        com.pulumi.azurenative.media.inputs.LiveEventEncodingArgs.builder()
            .encodingType(
                encodingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyFrameInterval(keyFrameInterval?.applyValue({ args0 -> args0 }))
            .presetName(presetName?.applyValue({ args0 -> args0 }))
            .stretchMode(
                stretchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LiveEventEncodingArgs].
 */
@PulumiTagMarker
public class LiveEventEncodingArgsBuilder internal constructor() {
    private var encodingType: Output<Either<String, LiveEventEncodingType>>? = null

    private var keyFrameInterval: Output<String>? = null

    private var presetName: Output<String>? = null

    private var stretchMode: Output<Either<String, StretchMode>>? = null

    /**
     * @param value Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
     */
    @JvmName("feqrnkbpynwnynqg")
    public suspend fun encodingType(`value`: Output<Either<String, LiveEventEncodingType>>) {
        this.encodingType = value
    }

    /**
     * @param value Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
     */
    @JvmName("hkyapblfuylblanv")
    public suspend fun keyFrameInterval(`value`: Output<String>) {
        this.keyFrameInterval = value
    }

    /**
     * @param value The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
     */
    @JvmName("tkgpoxgepmadvwkm")
    public suspend fun presetName(`value`: Output<String>) {
        this.presetName = value
    }

    /**
     * @param value Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
     */
    @JvmName("iyvnpijhojvovcwo")
    public suspend fun stretchMode(`value`: Output<Either<String, StretchMode>>) {
        this.stretchMode = value
    }

    /**
     * @param value Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
     */
    @JvmName("ysvkwwqnursphcok")
    public suspend fun encodingType(`value`: Either<String, LiveEventEncodingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodingType = mapped
    }

    /**
     * @param value Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
     */
    @JvmName("nhorxsytbmtcwqum")
    public fun encodingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LiveEventEncodingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encodingType = mapped
    }

    /**
     * @param value Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
     */
    @JvmName("fxsoyobdhptxhrab")
    public fun encodingType(`value`: LiveEventEncodingType) {
        val toBeMapped = Either.ofRight<String, LiveEventEncodingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encodingType = mapped
    }

    /**
     * @param value Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
     */
    @JvmName("dcpwmcfqsvjtshfd")
    public suspend fun keyFrameInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameInterval = mapped
    }

    /**
     * @param value The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
     */
    @JvmName("nelydnmnmtssgyja")
    public suspend fun presetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetName = mapped
    }

    /**
     * @param value Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
     */
    @JvmName("odbduiqmwxwpdild")
    public suspend fun stretchMode(`value`: Either<String, StretchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
     */
    @JvmName("ypjindfoesmhgjai")
    public fun stretchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
     */
    @JvmName("cwjlcyfpswngdoqp")
    public fun stretchMode(`value`: StretchMode) {
        val toBeMapped = Either.ofRight<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    internal fun build(): LiveEventEncodingArgs = LiveEventEncodingArgs(
        encodingType = encodingType,
        keyFrameInterval = keyFrameInterval,
        presetName = presetName,
        stretchMode = stretchMode,
    )
}
