@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventPreviewArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Live event preview settings.
 * @property accessControl The access control for live event preview.
 * @property alternativeMediaId An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
 * @property endpoints The endpoints for preview. Do not share the preview URL with the live event audience.
 * @property previewLocator The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
 * @property streamingPolicyName The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
 */
public data class LiveEventPreviewArgs(
    public val accessControl: Output<LiveEventPreviewAccessControlArgs>? = null,
    public val alternativeMediaId: Output<String>? = null,
    public val endpoints: Output<List<LiveEventEndpointArgs>>? = null,
    public val previewLocator: Output<String>? = null,
    public val streamingPolicyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventPreviewArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventPreviewArgs =
        com.pulumi.azurenative.media.inputs.LiveEventPreviewArgs.builder()
            .accessControl(accessControl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .alternativeMediaId(alternativeMediaId?.applyValue({ args0 -> args0 }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .previewLocator(previewLocator?.applyValue({ args0 -> args0 }))
            .streamingPolicyName(streamingPolicyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveEventPreviewArgs].
 */
@PulumiTagMarker
public class LiveEventPreviewArgsBuilder internal constructor() {
    private var accessControl: Output<LiveEventPreviewAccessControlArgs>? = null

    private var alternativeMediaId: Output<String>? = null

    private var endpoints: Output<List<LiveEventEndpointArgs>>? = null

    private var previewLocator: Output<String>? = null

    private var streamingPolicyName: Output<String>? = null

    /**
     * @param value The access control for live event preview.
     */
    @JvmName("whxldeoqcmcrjrqi")
    public suspend fun accessControl(`value`: Output<LiveEventPreviewAccessControlArgs>) {
        this.accessControl = value
    }

    /**
     * @param value An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
     */
    @JvmName("qbmtynosfiseyrgt")
    public suspend fun alternativeMediaId(`value`: Output<String>) {
        this.alternativeMediaId = value
    }

    /**
     * @param value The endpoints for preview. Do not share the preview URL with the live event audience.
     */
    @JvmName("frmiqbasukltswqn")
    public suspend fun endpoints(`value`: Output<List<LiveEventEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("nnkfeflrusbuusde")
    public suspend fun endpoints(vararg values: Output<LiveEventEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values The endpoints for preview. Do not share the preview URL with the live event audience.
     */
    @JvmName("hevidyochreoleck")
    public suspend fun endpoints(values: List<Output<LiveEventEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
     */
    @JvmName("bkwdtckgdjelssic")
    public suspend fun previewLocator(`value`: Output<String>) {
        this.previewLocator = value
    }

    /**
     * @param value The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
     */
    @JvmName("flvofyomxnmjediw")
    public suspend fun streamingPolicyName(`value`: Output<String>) {
        this.streamingPolicyName = value
    }

    /**
     * @param value The access control for live event preview.
     */
    @JvmName("ydntcjmxwfllflhf")
    public suspend fun accessControl(`value`: LiveEventPreviewAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControl = mapped
    }

    /**
     * @param argument The access control for live event preview.
     */
    @JvmName("myagnjyupruttwok")
    public suspend
    fun accessControl(argument: suspend LiveEventPreviewAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = LiveEventPreviewAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessControl = mapped
    }

    /**
     * @param value An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
     */
    @JvmName("ppsxvwmgdeldjfkt")
    public suspend fun alternativeMediaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternativeMediaId = mapped
    }

    /**
     * @param value The endpoints for preview. Do not share the preview URL with the live event audience.
     */
    @JvmName("pjbiewobqrhsrswh")
    public suspend fun endpoints(`value`: List<LiveEventEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument The endpoints for preview. Do not share the preview URL with the live event audience.
     */
    @JvmName("lmtaexeqhxcctlgl")
    public suspend fun endpoints(argument: List<suspend LiveEventEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LiveEventEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The endpoints for preview. Do not share the preview URL with the live event audience.
     */
    @JvmName("ihfsrwigtcoqpvds")
    public suspend fun endpoints(vararg argument: suspend LiveEventEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LiveEventEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The endpoints for preview. Do not share the preview URL with the live event audience.
     */
    @JvmName("xrvrnssjeajbjpct")
    public suspend fun endpoints(argument: suspend LiveEventEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LiveEventEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values The endpoints for preview. Do not share the preview URL with the live event audience.
     */
    @JvmName("jvjelppatlmowrro")
    public suspend fun endpoints(vararg values: LiveEventEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
     */
    @JvmName("mfbirosnaguludyr")
    public suspend fun previewLocator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.previewLocator = mapped
    }

    /**
     * @param value The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
     */
    @JvmName("gnaxybfjllaavtgx")
    public suspend fun streamingPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingPolicyName = mapped
    }

    internal fun build(): LiveEventPreviewArgs = LiveEventPreviewArgs(
        accessControl = accessControl,
        alternativeMediaId = alternativeMediaId,
        endpoints = endpoints,
        previewLocator = previewLocator,
        streamingPolicyName = streamingPolicyName,
    )
}
