@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaGraphPemCertificateListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A list of PEM formatted certificates.
 * @property certificates PEM formatted public certificates, one per entry.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphPemCertificateList'.
 */
public data class MediaGraphPemCertificateListArgs(
    public val certificates: Output<List<String>>,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaGraphPemCertificateListArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.MediaGraphPemCertificateListArgs =
        com.pulumi.azurenative.media.inputs.MediaGraphPemCertificateListArgs.builder()
            .certificates(certificates.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaGraphPemCertificateListArgs].
 */
@PulumiTagMarker
public class MediaGraphPemCertificateListArgsBuilder internal constructor() {
    private var certificates: Output<List<String>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value PEM formatted public certificates, one per entry.
     */
    @JvmName("pygevlrfhonmevnx")
    public suspend fun certificates(`value`: Output<List<String>>) {
        this.certificates = value
    }

    @JvmName("hogbwwnfqckjgcam")
    public suspend fun certificates(vararg values: Output<String>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values PEM formatted public certificates, one per entry.
     */
    @JvmName("tkttkfipaqgvhcyl")
    public suspend fun certificates(values: List<Output<String>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphPemCertificateList'.
     */
    @JvmName("qtlmmosgakcgjhwc")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value PEM formatted public certificates, one per entry.
     */
    @JvmName("mugkapjuoiytdkxu")
    public suspend fun certificates(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param values PEM formatted public certificates, one per entry.
     */
    @JvmName("otllcicjtpcmfcgu")
    public suspend fun certificates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphPemCertificateList'.
     */
    @JvmName("eoeyavdagvbeggpn")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): MediaGraphPemCertificateListArgs = MediaGraphPemCertificateListArgs(
        certificates = certificates ?: throw PulumiNullFieldException("certificates"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
