@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaGraphTlsEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An endpoint which must be connected over TLS/SSL.
 * @property credentials Polymorphic credentials to present to the endpoint.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphTlsEndpoint'.
 * @property trustedCertificates What certificates should be trusted when authenticating a TLS connection. Null designates that Azure Media's source of trust should be used.
 * @property url Url for the endpoint.
 * @property validationOptions Validation options to use when authenticating a TLS connection. By default, strict validation is used.
 */
public data class MediaGraphTlsEndpointArgs(
    public val credentials: Output<MediaGraphUsernamePasswordCredentialsArgs>? = null,
    public val odataType: Output<String>,
    public val trustedCertificates: Output<MediaGraphPemCertificateListArgs>? = null,
    public val url: Output<String>,
    public val validationOptions: Output<MediaGraphTlsValidationOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaGraphTlsEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.MediaGraphTlsEndpointArgs =
        com.pulumi.azurenative.media.inputs.MediaGraphTlsEndpointArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .trustedCertificates(
                trustedCertificates?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .url(url.applyValue({ args0 -> args0 }))
            .validationOptions(
                validationOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MediaGraphTlsEndpointArgs].
 */
@PulumiTagMarker
public class MediaGraphTlsEndpointArgsBuilder internal constructor() {
    private var credentials: Output<MediaGraphUsernamePasswordCredentialsArgs>? = null

    private var odataType: Output<String>? = null

    private var trustedCertificates: Output<MediaGraphPemCertificateListArgs>? = null

    private var url: Output<String>? = null

    private var validationOptions: Output<MediaGraphTlsValidationOptionsArgs>? = null

    /**
     * @param value Polymorphic credentials to present to the endpoint.
     */
    @JvmName("jnrxwbpkxmrlwgro")
    public suspend fun credentials(`value`: Output<MediaGraphUsernamePasswordCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphTlsEndpoint'.
     */
    @JvmName("fjdyivpkcphektdr")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value What certificates should be trusted when authenticating a TLS connection. Null designates that Azure Media's source of trust should be used.
     */
    @JvmName("mqkcycgruwcsvume")
    public suspend fun trustedCertificates(`value`: Output<MediaGraphPemCertificateListArgs>) {
        this.trustedCertificates = value
    }

    /**
     * @param value Url for the endpoint.
     */
    @JvmName("oyccnsycmfryyfww")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Validation options to use when authenticating a TLS connection. By default, strict validation is used.
     */
    @JvmName("vyxglwdcusmxufoi")
    public suspend fun validationOptions(`value`: Output<MediaGraphTlsValidationOptionsArgs>) {
        this.validationOptions = value
    }

    /**
     * @param value Polymorphic credentials to present to the endpoint.
     */
    @JvmName("noiehsilkbotisam")
    public suspend fun credentials(`value`: MediaGraphUsernamePasswordCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Polymorphic credentials to present to the endpoint.
     */
    @JvmName("swktsruynuhyjcjw")
    public suspend
    fun credentials(argument: suspend MediaGraphUsernamePasswordCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = MediaGraphUsernamePasswordCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphTlsEndpoint'.
     */
    @JvmName("vxkytecaecxjdxbn")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value What certificates should be trusted when authenticating a TLS connection. Null designates that Azure Media's source of trust should be used.
     */
    @JvmName("foweeygpgiaqvucu")
    public suspend fun trustedCertificates(`value`: MediaGraphPemCertificateListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCertificates = mapped
    }

    /**
     * @param argument What certificates should be trusted when authenticating a TLS connection. Null designates that Azure Media's source of trust should be used.
     */
    @JvmName("vathkvuhinikfbkj")
    public suspend
    fun trustedCertificates(argument: suspend MediaGraphPemCertificateListArgsBuilder.() -> Unit) {
        val toBeMapped = MediaGraphPemCertificateListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trustedCertificates = mapped
    }

    /**
     * @param value Url for the endpoint.
     */
    @JvmName("babjbvkdneshjkwo")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Validation options to use when authenticating a TLS connection. By default, strict validation is used.
     */
    @JvmName("folxbyiyxqqsbeht")
    public suspend fun validationOptions(`value`: MediaGraphTlsValidationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationOptions = mapped
    }

    /**
     * @param argument Validation options to use when authenticating a TLS connection. By default, strict validation is used.
     */
    @JvmName("lfewgmqnqqefxjqa")
    public suspend
    fun validationOptions(argument: suspend MediaGraphTlsValidationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = MediaGraphTlsValidationOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationOptions = mapped
    }

    internal fun build(): MediaGraphTlsEndpointArgs = MediaGraphTlsEndpointArgs(
        credentials = credentials,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        trustedCertificates = trustedCertificates,
        url = url ?: throw PulumiNullFieldException("url"),
        validationOptions = validationOptions,
    )
}
