@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaGraphUsernamePasswordCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Username/password credential pair.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphUsernamePasswordCredentials'.
 * @property password Password for a username/password pair.
 * @property username Username for a username/password pair.
 */
public data class MediaGraphUsernamePasswordCredentialsArgs(
    public val odataType: Output<String>,
    public val password: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaGraphUsernamePasswordCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.MediaGraphUsernamePasswordCredentialsArgs =
        com.pulumi.azurenative.media.inputs.MediaGraphUsernamePasswordCredentialsArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaGraphUsernamePasswordCredentialsArgs].
 */
@PulumiTagMarker
public class MediaGraphUsernamePasswordCredentialsArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphUsernamePasswordCredentials'.
     */
    @JvmName("spfiljvkgglhgmcv")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Password for a username/password pair.
     */
    @JvmName("drhygarselntfwwj")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Username for a username/password pair.
     */
    @JvmName("qfulqofboglbnwmr")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphUsernamePasswordCredentials'.
     */
    @JvmName("tphovnuvhsfpbmvg")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Password for a username/password pair.
     */
    @JvmName("qyagibsngvjgdkpb")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Username for a username/password pair.
     */
    @JvmName("yqhxuktbwytlvtev")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): MediaGraphUsernamePasswordCredentialsArgs =
        MediaGraphUsernamePasswordCredentialsArgs(
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
            password = password ?: throw PulumiNullFieldException("password"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
