@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaServiceIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property type The identity type.
 * @property userAssignedIdentities The user assigned managed identities.
 */
public data class MediaServiceIdentityArgs(
    public val type: Output<String>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaServiceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.MediaServiceIdentityArgs =
        com.pulumi.azurenative.media.inputs.MediaServiceIdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [MediaServiceIdentityArgs].
 */
@PulumiTagMarker
public class MediaServiceIdentityArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("knggsnogicssowoi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user assigned managed identities.
     */
    @JvmName("presgoolwsmkddaj")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("baskqysonoppqfbv")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The user assigned managed identities.
     */
    @JvmName("athdujxodfyynicj")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The identity type.
     */
    @JvmName("mvnapxhskejlxhls")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user assigned managed identities.
     */
    @JvmName("qxsikplxxdittdmg")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The user assigned managed identities.
     */
    @JvmName("afvdekerfxkayung")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): MediaServiceIdentityArgs = MediaServiceIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
