@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StandardEncoderPresetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes all the settings to be used when encoding the input video with the Standard Encoder.
 * @property codecs The list of codecs to be used when encoding the input video.
 * @property experimentalOptions Dictionary containing key value pairs for parameters not exposed in the preset itself
 * @property filters One or more filtering operations that are applied to the input media before encoding.
 * @property formats The list of outputs to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.StandardEncoderPreset'.
 */
public data class StandardEncoderPresetArgs(
    public val codecs: Output<List<Any>>,
    public val experimentalOptions: Output<Map<String, String>>? = null,
    public val filters: Output<FiltersArgs>? = null,
    public val formats: Output<List<Any>>,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StandardEncoderPresetArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.StandardEncoderPresetArgs =
        com.pulumi.azurenative.media.inputs.StandardEncoderPresetArgs.builder()
            .codecs(codecs.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .experimentalOptions(
                experimentalOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .formats(formats.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StandardEncoderPresetArgs].
 */
@PulumiTagMarker
public class StandardEncoderPresetArgsBuilder internal constructor() {
    private var codecs: Output<List<Any>>? = null

    private var experimentalOptions: Output<Map<String, String>>? = null

    private var filters: Output<FiltersArgs>? = null

    private var formats: Output<List<Any>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The list of codecs to be used when encoding the input video.
     */
    @JvmName("rytkwrgywxdvaclr")
    public suspend fun codecs(`value`: Output<List<Any>>) {
        this.codecs = value
    }

    @JvmName("lmscxxkxbjsttuod")
    public suspend fun codecs(vararg values: Output<Any>) {
        this.codecs = Output.all(values.asList())
    }

    /**
     * @param values The list of codecs to be used when encoding the input video.
     */
    @JvmName("abhamwsxswmneoxn")
    public suspend fun codecs(values: List<Output<Any>>) {
        this.codecs = Output.all(values)
    }

    /**
     * @param value Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("loxfaovgkpamjayt")
    public suspend fun experimentalOptions(`value`: Output<Map<String, String>>) {
        this.experimentalOptions = value
    }

    /**
     * @param value One or more filtering operations that are applied to the input media before encoding.
     */
    @JvmName("gdjgughbiaduqnor")
    public suspend fun filters(`value`: Output<FiltersArgs>) {
        this.filters = value
    }

    /**
     * @param value The list of outputs to be produced by the encoder.
     */
    @JvmName("lrygnekrrfaluvro")
    public suspend fun formats(`value`: Output<List<Any>>) {
        this.formats = value
    }

    @JvmName("nykitjeunjnqfawp")
    public suspend fun formats(vararg values: Output<Any>) {
        this.formats = Output.all(values.asList())
    }

    /**
     * @param values The list of outputs to be produced by the encoder.
     */
    @JvmName("wppbebkecmgpsbxc")
    public suspend fun formats(values: List<Output<Any>>) {
        this.formats = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.StandardEncoderPreset'.
     */
    @JvmName("sespjusniynbidkn")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The list of codecs to be used when encoding the input video.
     */
    @JvmName("lcgmrqqevfuamamh")
    public suspend fun codecs(`value`: List<Any>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codecs = mapped
    }

    /**
     * @param values The list of codecs to be used when encoding the input video.
     */
    @JvmName("vxounoldkuclraqa")
    public suspend fun codecs(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codecs = mapped
    }

    /**
     * @param value Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("lcxmocshfrvuwhmp")
    public suspend fun experimentalOptions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentalOptions = mapped
    }

    /**
     * @param values Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("sikolttyhlpgpgeg")
    public fun experimentalOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.experimentalOptions = mapped
    }

    /**
     * @param value One or more filtering operations that are applied to the input media before encoding.
     */
    @JvmName("uleolprarqmnmpux")
    public suspend fun filters(`value`: FiltersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument One or more filtering operations that are applied to the input media before encoding.
     */
    @JvmName("jsjxwntbgjbhgwvj")
    public suspend fun filters(argument: suspend FiltersArgsBuilder.() -> Unit) {
        val toBeMapped = FiltersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value The list of outputs to be produced by the encoder.
     */
    @JvmName("phhvbxvixbtulrxd")
    public suspend fun formats(`value`: List<Any>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.formats = mapped
    }

    /**
     * @param values The list of outputs to be produced by the encoder.
     */
    @JvmName("mbatlgouurgbyxqq")
    public suspend fun formats(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.formats = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.StandardEncoderPreset'.
     */
    @JvmName("jugxkvphldtfidhc")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): StandardEncoderPresetArgs = StandardEncoderPresetArgs(
        codecs = codecs ?: throw PulumiNullFieldException("codecs"),
        experimentalOptions = experimentalOptions,
        filters = filters,
        formats = formats ?: throw PulumiNullFieldException("formats"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
