@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StorageAccountArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.StorageAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The storage account details.
 * @property id The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
 * @property identity The storage account identity.
 * @property type The type of the storage account.
 */
public data class StorageAccountArgs(
    public val id: Output<String>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val type: Output<Either<String, StorageAccountType>>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.StorageAccountArgs =
        com.pulumi.azurenative.media.inputs.StorageAccountArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var type: Output<Either<String, StorageAccountType>>? = null

    /**
     * @param value The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
     */
    @JvmName("muqopoaibcswaqos")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The storage account identity.
     */
    @JvmName("qlgnylvddqrjetwa")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The type of the storage account.
     */
    @JvmName("yueyniqkigfphntj")
    public suspend fun type(`value`: Output<Either<String, StorageAccountType>>) {
        this.type = value
    }

    /**
     * @param value The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
     */
    @JvmName("nauturpbvoaoxyae")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The storage account identity.
     */
    @JvmName("bkjlsushuryljuao")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The storage account identity.
     */
    @JvmName("ldmmgjjfmlevfqxc")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The type of the storage account.
     */
    @JvmName("fyhnuinyuuxwcnhy")
    public suspend fun type(`value`: Either<String, StorageAccountType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the storage account.
     */
    @JvmName("jjghmfmhctuqoupi")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the storage account.
     */
    @JvmName("iqsajdocadeepxgb")
    public fun type(`value`: StorageAccountType) {
        val toBeMapped = Either.ofRight<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        id = id,
        identity = identity,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
