@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.TextTrackArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.Visibility
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
 * @property displayName The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
 * @property fileName The file name to the source file. This file is located in the storage container of the asset.
 * @property hlsSettings The HLS specific setting for the text track.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.TextTrack'.
 * @property playerVisibility When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
 */
public data class TextTrackArgs(
    public val displayName: Output<String>? = null,
    public val fileName: Output<String>? = null,
    public val hlsSettings: Output<HlsSettingsArgs>? = null,
    public val odataType: Output<String>,
    public val playerVisibility: Output<Either<String, Visibility>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.TextTrackArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.TextTrackArgs =
        com.pulumi.azurenative.media.inputs.TextTrackArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .hlsSettings(hlsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .playerVisibility(
                playerVisibility?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [TextTrackArgs].
 */
@PulumiTagMarker
public class TextTrackArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var fileName: Output<String>? = null

    private var hlsSettings: Output<HlsSettingsArgs>? = null

    private var odataType: Output<String>? = null

    private var playerVisibility: Output<Either<String, Visibility>>? = null

    /**
     * @param value The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
     */
    @JvmName("rrarudugptxhbput")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The file name to the source file. This file is located in the storage container of the asset.
     */
    @JvmName("equbcekhjuyujbtd")
    public suspend fun fileName(`value`: Output<String>) {
        this.fileName = value
    }

    /**
     * @param value The HLS specific setting for the text track.
     */
    @JvmName("aaobndnvlgolwign")
    public suspend fun hlsSettings(`value`: Output<HlsSettingsArgs>) {
        this.hlsSettings = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.TextTrack'.
     */
    @JvmName("ienohiewevenjxim")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
     */
    @JvmName("ncyybhwsliyxsjir")
    public suspend fun playerVisibility(`value`: Output<Either<String, Visibility>>) {
        this.playerVisibility = value
    }

    /**
     * @param value The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
     */
    @JvmName("jygwbyustvlciyii")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The file name to the source file. This file is located in the storage container of the asset.
     */
    @JvmName("avwgamxbitvwwvnj")
    public suspend fun fileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value The HLS specific setting for the text track.
     */
    @JvmName("sqhkgokuevjrgwyg")
    public suspend fun hlsSettings(`value`: HlsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hlsSettings = mapped
    }

    /**
     * @param argument The HLS specific setting for the text track.
     */
    @JvmName("ngbovydcokbjxdty")
    public suspend fun hlsSettings(argument: suspend HlsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = HlsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hlsSettings = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.TextTrack'.
     */
    @JvmName("helbgxvtrehusmpo")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
     */
    @JvmName("wuxkpavxkaofvifp")
    public suspend fun playerVisibility(`value`: Either<String, Visibility>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playerVisibility = mapped
    }

    /**
     * @param value When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
     */
    @JvmName("sicrxwhcjmhfbtfr")
    public fun playerVisibility(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.playerVisibility = mapped
    }

    /**
     * @param value When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
     */
    @JvmName("uubuhgfqbxujnbfk")
    public fun playerVisibility(`value`: Visibility) {
        val toBeMapped = Either.ofRight<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.playerVisibility = mapped
    }

    internal fun build(): TextTrackArgs = TextTrackArgs(
        displayName = displayName,
        fileName = fileName,
        hlsSettings = hlsSettings,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        playerVisibility = playerVisibility,
    )
}
