@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.TransportStreamFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).
 * @property filenamePattern The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.TransportStreamFormat'.
 * @property outputFiles The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
 */
public data class TransportStreamFormatArgs(
    public val filenamePattern: Output<String>,
    public val odataType: Output<String>,
    public val outputFiles: Output<List<OutputFileArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.TransportStreamFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.TransportStreamFormatArgs =
        com.pulumi.azurenative.media.inputs.TransportStreamFormatArgs.builder()
            .filenamePattern(filenamePattern.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .outputFiles(
                outputFiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TransportStreamFormatArgs].
 */
@PulumiTagMarker
public class TransportStreamFormatArgsBuilder internal constructor() {
    private var filenamePattern: Output<String>? = null

    private var odataType: Output<String>? = null

    private var outputFiles: Output<List<OutputFileArgs>>? = null

    /**
     * @param value The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
     */
    @JvmName("dncuvavvmmklascq")
    public suspend fun filenamePattern(`value`: Output<String>) {
        this.filenamePattern = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.TransportStreamFormat'.
     */
    @JvmName("sxoofkydiusqswby")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
     */
    @JvmName("ltkkbwosnpbolgsd")
    public suspend fun outputFiles(`value`: Output<List<OutputFileArgs>>) {
        this.outputFiles = value
    }

    @JvmName("evdkqxwbfsidgdwk")
    public suspend fun outputFiles(vararg values: Output<OutputFileArgs>) {
        this.outputFiles = Output.all(values.asList())
    }

    /**
     * @param values The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
     */
    @JvmName("eydhkoiiyqlxqmrn")
    public suspend fun outputFiles(values: List<Output<OutputFileArgs>>) {
        this.outputFiles = Output.all(values)
    }

    /**
     * @param value The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
     */
    @JvmName("tqouwfgxiujufpdd")
    public suspend fun filenamePattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filenamePattern = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.TransportStreamFormat'.
     */
    @JvmName("loosjjvopbkdqavh")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
     */
    @JvmName("ergfmmfryjvijevk")
    public suspend fun outputFiles(`value`: List<OutputFileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputFiles = mapped
    }

    /**
     * @param argument The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
     */
    @JvmName("blmunskfcpwswpix")
    public suspend fun outputFiles(argument: List<suspend OutputFileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { OutputFileArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.outputFiles = mapped
    }

    /**
     * @param argument The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
     */
    @JvmName("onpvrcxmhmtnyuve")
    public suspend fun outputFiles(vararg argument: suspend OutputFileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { OutputFileArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.outputFiles = mapped
    }

    /**
     * @param argument The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
     */
    @JvmName("taohekaonvticgeg")
    public suspend fun outputFiles(argument: suspend OutputFileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OutputFileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outputFiles = mapped
    }

    /**
     * @param values The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
     */
    @JvmName("yqgogrfbrssplubg")
    public suspend fun outputFiles(vararg values: OutputFileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputFiles = mapped
    }

    internal fun build(): TransportStreamFormatArgs = TransportStreamFormatArgs(
        filenamePattern = filenamePattern ?: throw PulumiNullFieldException("filenamePattern"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        outputFiles = outputFiles,
    )
}
