@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.VideoArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.StretchMode
import com.pulumi.azurenative.media.kotlin.enums.VideoSyncMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the basic properties for encoding the input video.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.Video'.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class VideoArgs(
    public val keyFrameInterval: Output<String>? = null,
    public val label: Output<String>? = null,
    public val odataType: Output<String>,
    public val stretchMode: Output<Either<String, StretchMode>>? = null,
    public val syncMode: Output<Either<String, VideoSyncMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.VideoArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.VideoArgs =
        com.pulumi.azurenative.media.inputs.VideoArgs.builder()
            .keyFrameInterval(keyFrameInterval?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .stretchMode(
                stretchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syncMode(
                syncMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VideoArgs].
 */
@PulumiTagMarker
public class VideoArgsBuilder internal constructor() {
    private var keyFrameInterval: Output<String>? = null

    private var label: Output<String>? = null

    private var odataType: Output<String>? = null

    private var stretchMode: Output<Either<String, StretchMode>>? = null

    private var syncMode: Output<Either<String, VideoSyncMode>>? = null

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("gfeavapgpuejouqc")
    public suspend fun keyFrameInterval(`value`: Output<String>) {
        this.keyFrameInterval = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("gnwbkmtcyykthopy")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.Video'.
     */
    @JvmName("jadvplaciqkpnddn")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("fbxqhsxafufchdcy")
    public suspend fun stretchMode(`value`: Output<Either<String, StretchMode>>) {
        this.stretchMode = value
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("sgvgjarvvleemxgm")
    public suspend fun syncMode(`value`: Output<Either<String, VideoSyncMode>>) {
        this.syncMode = value
    }

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("lvkaqhqpihrkybsn")
    public suspend fun keyFrameInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameInterval = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("nyppyseamhlrqnkh")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.Video'.
     */
    @JvmName("wfishyucipcbdigi")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("aneypfwgfkojadta")
    public suspend fun stretchMode(`value`: Either<String, StretchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("srklevnnefbrvgeu")
    public fun stretchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("hqxyqlknmebverfc")
    public fun stretchMode(`value`: StretchMode) {
        val toBeMapped = Either.ofRight<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("egalbvwwpgtahdct")
    public suspend fun syncMode(`value`: Either<String, VideoSyncMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("bmrlopesyqesvghy")
    public fun syncMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("vcvlarvvqlgbjkpe")
    public fun syncMode(`value`: VideoSyncMode) {
        val toBeMapped = Either.ofRight<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    internal fun build(): VideoArgs = VideoArgs(
        keyFrameInterval = keyFrameInterval,
        label = label,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        stretchMode = stretchMode,
        syncMode = syncMode,
    )
}
