@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the clip time as an absolute time position in the media file.  The absolute time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AbsoluteClipTime'.
 * @property time The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
 */
public data class AbsoluteClipTimeResponse(
    public val odataType: String,
    public val time: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AbsoluteClipTimeResponse):
            AbsoluteClipTimeResponse = AbsoluteClipTimeResponse(
            odataType = javaType.odataType(),
            time = javaType.time(),
        )
    }
}
