@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Akamai Signature Header authentication key.
 * @property base64Key authentication key
 * @property expiration The expiration time of the authentication key.
 * @property identifier identifier of the key
 */
public data class AkamaiSignatureHeaderAuthenticationKeyResponse(
    public val base64Key: String? = null,
    public val expiration: String? = null,
    public val identifier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AkamaiSignatureHeaderAuthenticationKeyResponse):
            AkamaiSignatureHeaderAuthenticationKeyResponse =
            AkamaiSignatureHeaderAuthenticationKeyResponse(
                base64Key = javaType.base64Key().map({ args0 -> args0 }).orElse(null),
                expiration = javaType.expiration().map({ args0 -> args0 }).orElse(null),
                identifier = javaType.identifier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
