@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
 * @property customKeysAcquisitionUrlTemplate Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
 */
public data class ClearKeyEncryptionConfigurationResponse(
    public val customKeysAcquisitionUrlTemplate: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ClearKeyEncryptionConfigurationResponse):
            ClearKeyEncryptionConfigurationResponse = ClearKeyEncryptionConfigurationResponse(
            customKeysAcquisitionUrlTemplate = javaType.customKeysAcquisitionUrlTemplate().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
