@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a configuration for non-DRM keys.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
 */
public data class ContentKeyPolicyClearKeyConfigurationResponse(
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyClearKeyConfigurationResponse):
            ContentKeyPolicyClearKeyConfigurationResponse =
            ContentKeyPolicyClearKeyConfigurationResponse(
                odataType = javaType.odataType(),
            )
    }
}
