@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies that the content key ID is in the PlayReady header.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
 */
public data class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse(
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse):
            ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse =
            ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse(
                odataType = javaType.odataType(),
            )
    }
}
