@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Class to specify which protocols are enabled
 * @property dash Enable DASH protocol or not
 * @property download Enable Download protocol or not
 * @property hls Enable HLS protocol or not
 * @property smoothStreaming Enable SmoothStreaming protocol or not
 */
public data class EnabledProtocolsResponse(
    public val dash: Boolean,
    public val download: Boolean,
    public val hls: Boolean,
    public val smoothStreaming: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.EnabledProtocolsResponse):
            EnabledProtocolsResponse = EnabledProtocolsResponse(
            dash = javaType.dash(),
            download = javaType.download(),
            hls = javaType.hls(),
            smoothStreaming = javaType.smoothStreaming(),
        )
    }
}
