@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each file given.
 * @property includedTracks The list of TrackDescriptors which define the metadata and selection of tracks in the input.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.FromEachInputFile'.
 */
public data class FromEachInputFileResponse(
    public val includedTracks: List<Any>? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.FromEachInputFileResponse):
            FromEachInputFileResponse = FromEachInputFileResponse(
            includedTracks = javaType.includedTracks().map({ args0 -> args0 }),
            odataType = javaType.odataType(),
        )
    }
}
