@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes all the properties for encoding a video with the H.265 codec.
 * @property complexity Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property layers The collection of output H.265 layers to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.H265Video'.
 * @property sceneChangeDetection Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class H265VideoResponse(
    public val complexity: String? = null,
    public val keyFrameInterval: String? = null,
    public val label: String? = null,
    public val layers: List<H265LayerResponse>? = null,
    public val odataType: String,
    public val sceneChangeDetection: Boolean? = null,
    public val stretchMode: String? = null,
    public val syncMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.H265VideoResponse):
            H265VideoResponse = H265VideoResponse(
            complexity = javaType.complexity().map({ args0 -> args0 }).orElse(null),
            keyFrameInterval = javaType.keyFrameInterval().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            layers = javaType.layers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.H265LayerResponse.Companion.toKotlin(args0)
                })
            }),
            odataType = javaType.odataType(),
            sceneChangeDetection = javaType.sceneChangeDetection().map({ args0 -> args0 }).orElse(null),
            stretchMode = javaType.stretchMode().map({ args0 -> args0 }).orElse(null),
            syncMode = javaType.syncMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
