@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A Sequence contains an ordered list of Clips where each clip is a JobInput.  The Sequence will be treated as a single input.
 * @property inputs JobInputs that make up the timeline.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JobInputSequence'.
 */
public data class JobInputSequenceResponse(
    public val inputs: List<JobInputClipResponse>? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.JobInputSequenceResponse):
            JobInputSequenceResponse = JobInputSequenceResponse(
            inputs = javaType.inputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.JobInputClipResponse.Companion.toKotlin(args0)
                })
            }),
            odataType = javaType.odataType(),
        )
    }
}
