@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The live event endpoint.
 * @property protocol The endpoint protocol.
 * @property url The endpoint URL.
 */
public data class LiveEventEndpointResponse(
    public val protocol: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventEndpointResponse):
            LiveEventEndpointResponse = LiveEventEndpointResponse(
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
