@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An endpoint to connect to with no encryption in transit.
 * @property credentials Polymorphic credentials to present to the endpoint.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphClearEndpoint'.
 * @property url Url for the endpoint.
 */
public data class MediaGraphClearEndpointResponse(
    public val credentials: MediaGraphUsernamePasswordCredentialsResponse? = null,
    public val odataType: String,
    public val url: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.MediaGraphClearEndpointResponse):
            MediaGraphClearEndpointResponse = MediaGraphClearEndpointResponse(
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.MediaGraphUsernamePasswordCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            odataType = javaType.odataType(),
            url = javaType.url(),
        )
    }
}
