@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 * The presentation time range, this is asset related and not recommended for Account Filter.
 * @property endTimestamp The absolute end time boundary.
 * @property forceEndTimestamp The indicator of forcing existing of end time stamp.
 * @property liveBackoffDuration The relative to end right edge.
 * @property presentationWindowDuration The relative to end sliding window.
 * @property startTimestamp The absolute start time boundary.
 * @property timescale The time scale of time stamps.
 */
public data class PresentationTimeRangeResponse(
    public val endTimestamp: Double? = null,
    public val forceEndTimestamp: Boolean? = null,
    public val liveBackoffDuration: Double? = null,
    public val presentationWindowDuration: Double? = null,
    public val startTimestamp: Double? = null,
    public val timescale: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.PresentationTimeRangeResponse):
            PresentationTimeRangeResponse = PresentationTimeRangeResponse(
            endTimestamp = javaType.endTimestamp().map({ args0 -> args0 }).orElse(null),
            forceEndTimestamp = javaType.forceEndTimestamp().map({ args0 -> args0 }).orElse(null),
            liveBackoffDuration = javaType.liveBackoffDuration().map({ args0 -> args0 }).orElse(null),
            presentationWindowDuration = javaType.presentationWindowDuration().map({ args0 ->
                args0
            }).orElse(null),
            startTimestamp = javaType.startTimestamp().map({ args0 -> args0 }).orElse(null),
            timescale = javaType.timescale().map({ args0 -> args0 }).orElse(null),
        )
    }
}
