@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of a rectangular window applied to the input media before processing it.
 * @property height The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 * @property left The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 * @property top The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 * @property width The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 */
public data class RectangleResponse(
    public val height: String? = null,
    public val left: String? = null,
    public val top: String? = null,
    public val width: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.RectangleResponse):
            RectangleResponse = RectangleResponse(
            height = javaType.height().map({ args0 -> args0 }).orElse(null),
            left = javaType.left().map({ args0 -> args0 }).orElse(null),
            top = javaType.top().map({ args0 -> args0 }).orElse(null),
            width = javaType.width().map({ args0 -> args0 }).orElse(null),
        )
    }
}
