@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Select video tracks from the input by specifying a track identifier.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectVideoTrackById'.
 * @property trackId Track identifier to select
 */
public data class SelectVideoTrackByIdResponse(
    public val odataType: String,
    public val trackId: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.SelectVideoTrackByIdResponse):
            SelectVideoTrackByIdResponse = SelectVideoTrackByIdResponse(
            odataType = javaType.odataType(),
            trackId = javaType.trackId(),
        )
    }
}
