@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class to specify one track property condition
 * @property operation Track property condition operation
 * @property property Track property type
 * @property value Track property value
 */
public data class TrackPropertyConditionResponse(
    public val operation: String,
    public val `property`: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.TrackPropertyConditionResponse):
            TrackPropertyConditionResponse = TrackPropertyConditionResponse(
            operation = javaType.operation(),
            `property` = javaType.`property`(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
