@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the clip time as a Utc time position in the media file.  The Utc time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.UtcClipTime'.
 * @property time The time position on the timeline of the input media based on Utc time.
 */
public data class UtcClipTimeResponse(
    public val odataType: String,
    public val time: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.UtcClipTimeResponse):
            UtcClipTimeResponse = UtcClipTimeResponse(
            odataType = javaType.odataType(),
            time = javaType.time(),
        )
    }
}
