@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.AKSAssessmentDetailsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.AKSAssessmentSettingsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.AssessmentScopeParametersResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.AKSAssessmentDetailsResponse.Companion.toKotlin as aKSAssessmentDetailsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.AKSAssessmentSettingsResponse.Companion.toKotlin as aKSAssessmentSettingsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.AssessmentScopeParametersResponse.Companion.toKotlin as assessmentScopeParametersResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AksAssessmentOperation].
 */
@PulumiTagMarker
public class AksAssessmentOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AksAssessmentOperationArgs = AksAssessmentOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AksAssessmentOperationArgsBuilder.() -> Unit) {
        val builder = AksAssessmentOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AksAssessmentOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.AksAssessmentOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AksAssessmentOperation(builtJavaResource)
    }
}

/**
 * ARM model of AKS Assessment.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### AksAssessmentOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var aksAssessmentOperation = new AzureNative.Migrate.AksAssessmentOperation("aksAssessmentOperation", new()
 *     {
 *         AssessmentName = "testaksassessment",
 *         ProjectName = "testproject",
 *         ResourceGroupName = "rgaksswagger",
 *         Scope = new AzureNative.Migrate.Inputs.AssessmentScopeParametersArgs
 *         {
 *             ServerGroupId = "/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp",
 *         },
 *         Settings = new AzureNative.Migrate.Inputs.AKSAssessmentSettingsArgs
 *         {
 *             AzureLocation = "Unknown",
 *             Category = "All",
 *             Consolidation = "Full",
 *             Currency = "Unknown",
 *             DiscountPercentage = 15,
 *             EnvironmentType = "Unknown",
 *             LicensingProgram = "Default",
 *             PerformanceData = new AzureNative.Migrate.Inputs.PerfDataSettingsArgs
 *             {
 *                 Percentile = "Percentile50",
 *                 PerfDataEndTime = "2023-11-07T06:51:24.320Z",
 *                 PerfDataStartTime = "2023-11-07T06:51:24.320Z",
 *                 TimeRange = "Day",
 *             },
 *             PricingTier = "Standard",
 *             SavingsOptions = "None",
 *             ScalingFactor = 3,
 *             SizingCriteria = "PerformanceBased",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAksAssessmentOperation(ctx, "aksAssessmentOperation", &migrate.AksAssessmentOperationArgs{
 * 			AssessmentName:    pulumi.String("testaksassessment"),
 * 			ProjectName:       pulumi.String("testproject"),
 * 			ResourceGroupName: pulumi.String("rgaksswagger"),
 * 			Scope: &migrate.AssessmentScopeParametersArgs{
 * 				ServerGroupId: pulumi.String("/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp"),
 * 			},
 * 			Settings: migrate.AKSAssessmentSettingsResponse{
 * 				AzureLocation:      pulumi.String("Unknown"),
 * 				Category:           pulumi.String("All"),
 * 				Consolidation:      pulumi.String("Full"),
 * 				Currency:           pulumi.String("Unknown"),
 * 				DiscountPercentage: pulumi.Float64(15),
 * 				EnvironmentType:    pulumi.String("Unknown"),
 * 				LicensingProgram:   pulumi.String("Default"),
 * 				PerformanceData: &migrate.PerfDataSettingsArgs{
 * 					Percentile:        pulumi.String("Percentile50"),
 * 					PerfDataEndTime:   pulumi.String("2023-11-07T06:51:24.320Z"),
 * 					PerfDataStartTime: pulumi.String("2023-11-07T06:51:24.320Z"),
 * 					TimeRange:         pulumi.String("Day"),
 * 				},
 * 				PricingTier:    pulumi.String("Standard"),
 * 				SavingsOptions: pulumi.String("None"),
 * 				ScalingFactor:  pulumi.Float64(3),
 * 				SizingCriteria: pulumi.String("PerformanceBased"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AksAssessmentOperation;
 * import com.pulumi.azurenative.migrate.AksAssessmentOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var aksAssessmentOperation = new AksAssessmentOperation("aksAssessmentOperation", AksAssessmentOperationArgs.builder()
 *             .assessmentName("testaksassessment")
 *             .projectName("testproject")
 *             .resourceGroupName("rgaksswagger")
 *             .scope(Map.of("serverGroupId", "/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp"))
 *             .settings(Map.ofEntries(
 *                 Map.entry("azureLocation", "Unknown"),
 *                 Map.entry("category", "All"),
 *                 Map.entry("consolidation", "Full"),
 *                 Map.entry("currency", "Unknown"),
 *                 Map.entry("discountPercentage", 15),
 *                 Map.entry("environmentType", "Unknown"),
 *                 Map.entry("licensingProgram", "Default"),
 *                 Map.entry("performanceData", Map.ofEntries(
 *                     Map.entry("percentile", "Percentile50"),
 *                     Map.entry("perfDataEndTime", "2023-11-07T06:51:24.320Z"),
 *                     Map.entry("perfDataStartTime", "2023-11-07T06:51:24.320Z"),
 *                     Map.entry("timeRange", "Day")
 *                 )),
 *                 Map.entry("pricingTier", "Standard"),
 *                 Map.entry("savingsOptions", "None"),
 *                 Map.entry("scalingFactor", 3),
 *                 Map.entry("sizingCriteria", "PerformanceBased")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AksAssessmentOperation testaksassessment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/aksAssessments/{assessmentName}
 * ```
 */
public class AksAssessmentOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.AksAssessmentOperation,
) : KotlinCustomResource(javaResource, AksAssessmentOperationMapper) {
    /**
     * Gets AKS Assessment Details.
     */
    public val details: Output<AKSAssessmentDetailsResponse>
        get() = javaResource.details().applyValue({ args0 ->
            args0.let({ args0 ->
                aKSAssessmentDetailsResponseToKotlin(args0)
            })
        })

    /**
     * If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets scope parameters to identify inventory items for assessment.
     */
    public val scope: Output<AssessmentScopeParametersResponse>?
        get() = javaResource.scope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assessmentScopeParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets AKS Assessment Settings.
     */
    public val settings: Output<AKSAssessmentSettingsResponse>
        get() = javaResource.settings().applyValue({ args0 ->
            args0.let({ args0 ->
                aKSAssessmentSettingsResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AksAssessmentOperationMapper : ResourceMapper<AksAssessmentOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.AksAssessmentOperation::class == javaResource::class

    override fun map(javaResource: Resource): AksAssessmentOperation =
        AksAssessmentOperation(javaResource as com.pulumi.azurenative.migrate.AksAssessmentOperation)
}

/**
 * @see [AksAssessmentOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AksAssessmentOperation].
 */
public suspend fun aksAssessmentOperation(
    name: String,
    block: suspend AksAssessmentOperationResourceBuilder.() -> Unit,
): AksAssessmentOperation {
    val builder = AksAssessmentOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AksAssessmentOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aksAssessmentOperation(name: String): AksAssessmentOperation {
    val builder = AksAssessmentOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
