@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.AksAssessmentOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.AKSAssessmentSettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AKSAssessmentSettingsArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentScopeParametersArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentScopeParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ARM model of AKS Assessment.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### AksAssessmentOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var aksAssessmentOperation = new AzureNative.Migrate.AksAssessmentOperation("aksAssessmentOperation", new()
 *     {
 *         AssessmentName = "testaksassessment",
 *         ProjectName = "testproject",
 *         ResourceGroupName = "rgaksswagger",
 *         Scope = new AzureNative.Migrate.Inputs.AssessmentScopeParametersArgs
 *         {
 *             ServerGroupId = "/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp",
 *         },
 *         Settings = new AzureNative.Migrate.Inputs.AKSAssessmentSettingsArgs
 *         {
 *             AzureLocation = "Unknown",
 *             Category = "All",
 *             Consolidation = "Full",
 *             Currency = "Unknown",
 *             DiscountPercentage = 15,
 *             EnvironmentType = "Unknown",
 *             LicensingProgram = "Default",
 *             PerformanceData = new AzureNative.Migrate.Inputs.PerfDataSettingsArgs
 *             {
 *                 Percentile = "Percentile50",
 *                 PerfDataEndTime = "2023-11-07T06:51:24.320Z",
 *                 PerfDataStartTime = "2023-11-07T06:51:24.320Z",
 *                 TimeRange = "Day",
 *             },
 *             PricingTier = "Standard",
 *             SavingsOptions = "None",
 *             ScalingFactor = 3,
 *             SizingCriteria = "PerformanceBased",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAksAssessmentOperation(ctx, "aksAssessmentOperation", &migrate.AksAssessmentOperationArgs{
 * 			AssessmentName:    pulumi.String("testaksassessment"),
 * 			ProjectName:       pulumi.String("testproject"),
 * 			ResourceGroupName: pulumi.String("rgaksswagger"),
 * 			Scope: &migrate.AssessmentScopeParametersArgs{
 * 				ServerGroupId: pulumi.String("/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp"),
 * 			},
 * 			Settings: migrate.AKSAssessmentSettingsResponse{
 * 				AzureLocation:      pulumi.String("Unknown"),
 * 				Category:           pulumi.String("All"),
 * 				Consolidation:      pulumi.String("Full"),
 * 				Currency:           pulumi.String("Unknown"),
 * 				DiscountPercentage: pulumi.Float64(15),
 * 				EnvironmentType:    pulumi.String("Unknown"),
 * 				LicensingProgram:   pulumi.String("Default"),
 * 				PerformanceData: &migrate.PerfDataSettingsArgs{
 * 					Percentile:        pulumi.String("Percentile50"),
 * 					PerfDataEndTime:   pulumi.String("2023-11-07T06:51:24.320Z"),
 * 					PerfDataStartTime: pulumi.String("2023-11-07T06:51:24.320Z"),
 * 					TimeRange:         pulumi.String("Day"),
 * 				},
 * 				PricingTier:    pulumi.String("Standard"),
 * 				SavingsOptions: pulumi.String("None"),
 * 				ScalingFactor:  pulumi.Float64(3),
 * 				SizingCriteria: pulumi.String("PerformanceBased"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AksAssessmentOperation;
 * import com.pulumi.azurenative.migrate.AksAssessmentOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var aksAssessmentOperation = new AksAssessmentOperation("aksAssessmentOperation", AksAssessmentOperationArgs.builder()
 *             .assessmentName("testaksassessment")
 *             .projectName("testproject")
 *             .resourceGroupName("rgaksswagger")
 *             .scope(Map.of("serverGroupId", "/subscriptions/D6F60DF4-CE70-4E39-8217-B8FBE7CA85AA/resourceGroups/rgaksswagger/providers/Microsoft.Migrate/assessmentProjects/testproject/groups/testgrp"))
 *             .settings(Map.ofEntries(
 *                 Map.entry("azureLocation", "Unknown"),
 *                 Map.entry("category", "All"),
 *                 Map.entry("consolidation", "Full"),
 *                 Map.entry("currency", "Unknown"),
 *                 Map.entry("discountPercentage", 15),
 *                 Map.entry("environmentType", "Unknown"),
 *                 Map.entry("licensingProgram", "Default"),
 *                 Map.entry("performanceData", Map.ofEntries(
 *                     Map.entry("percentile", "Percentile50"),
 *                     Map.entry("perfDataEndTime", "2023-11-07T06:51:24.320Z"),
 *                     Map.entry("perfDataStartTime", "2023-11-07T06:51:24.320Z"),
 *                     Map.entry("timeRange", "Day")
 *                 )),
 *                 Map.entry("pricingTier", "Standard"),
 *                 Map.entry("savingsOptions", "None"),
 *                 Map.entry("scalingFactor", 3),
 *                 Map.entry("sizingCriteria", "PerformanceBased")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AksAssessmentOperation testaksassessment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/aksAssessments/{assessmentName}
 * ```
 * @property assessmentName AKS Assessment Name.
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Gets or sets scope parameters to identify inventory items for assessment.
 * @property settings Gets or sets AKS Assessment Settings.
 */
public data class AksAssessmentOperationArgs(
    public val assessmentName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<AssessmentScopeParametersArgs>? = null,
    public val settings: Output<AKSAssessmentSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.AksAssessmentOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.AksAssessmentOperationArgs =
        com.pulumi.azurenative.migrate.AksAssessmentOperationArgs.builder()
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AksAssessmentOperationArgs].
 */
@PulumiTagMarker
public class AksAssessmentOperationArgsBuilder internal constructor() {
    private var assessmentName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<AssessmentScopeParametersArgs>? = null

    private var settings: Output<AKSAssessmentSettingsArgs>? = null

    /**
     * @param value AKS Assessment Name.
     */
    @JvmName("drhfpcqfkvcamads")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("qdvhxdmciemkcudj")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("chirdjsauhtvxyal")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets scope parameters to identify inventory items for assessment.
     */
    @JvmName("hultaeagwoeddjcf")
    public suspend fun scope(`value`: Output<AssessmentScopeParametersArgs>) {
        this.scope = value
    }

    /**
     * @param value Gets or sets AKS Assessment Settings.
     */
    @JvmName("jliplcgekmvviqkn")
    public suspend fun settings(`value`: Output<AKSAssessmentSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value AKS Assessment Name.
     */
    @JvmName("syhxslofcvrixoup")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ebeggquxtyfjpwhy")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jforrjyiqbbtqxvq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets scope parameters to identify inventory items for assessment.
     */
    @JvmName("xerbdymirdnvhpln")
    public suspend fun scope(`value`: AssessmentScopeParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument Gets or sets scope parameters to identify inventory items for assessment.
     */
    @JvmName("ynklotlxcjyejspj")
    public suspend fun scope(argument: suspend AssessmentScopeParametersArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentScopeParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value Gets or sets AKS Assessment Settings.
     */
    @JvmName("dpwbfytcalytpiun")
    public suspend fun settings(`value`: AKSAssessmentSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Gets or sets AKS Assessment Settings.
     */
    @JvmName("llbwelxylnpwdkrj")
    public suspend fun settings(argument: suspend AKSAssessmentSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AKSAssessmentSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    internal fun build(): AksAssessmentOperationArgs = AksAssessmentOperationArgs(
        assessmentName = assessmentName,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        scope = scope,
        settings = settings,
    )
}
