@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.AssessmentArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An assessment created for a group in the Migration project.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2017-11-11-preview, 2018-02-02.
 * ## Example Usage
 * ### Assessments_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessment = new AzureNative.Migrate.Assessment("assessment", new()
 *     {
 *         AssessmentName = "assessment_5_14_2019_16_48_47",
 *         ETag = "\"1e000c2c-0000-0d00-0000-5cdaa4190000\"",
 *         GroupName = "Group2",
 *         ProjectName = "abgoyalWEselfhostb72bproject",
 *         Properties = new AzureNative.Migrate.Inputs.AssessmentPropertiesArgs
 *         {
 *             AzureDiskType = "StandardOrPremium",
 *             AzureHybridUseBenefit = "Yes",
 *             AzureLocation = "NorthEurope",
 *             AzureOfferCode = "MSAZR0003P",
 *             AzurePricingTier = "Standard",
 *             AzureStorageRedundancy = "LocallyRedundant",
 *             AzureVmFamilies = new[]
 *             {
 *                 "Dv2_series",
 *                 "F_series",
 *                 "Dv3_series",
 *                 "DS_series",
 *                 "DSv2_series",
 *                 "Fs_series",
 *                 "Dsv3_series",
 *                 "Ev3_series",
 *                 "Esv3_series",
 *                 "D_series",
 *                 "M_series",
 *                 "Fsv2_series",
 *                 "H_series",
 *             },
 *             Currency = "USD",
 *             DiscountPercentage = 100,
 *             Percentile = "Percentile95",
 *             ReservedInstance = "RI3Year",
 *             ScalingFactor = 1,
 *             SizingCriterion = "PerformanceBased",
 *             Stage = "InProgress",
 *             TimeRange = "Day",
 *             VmUptime = new AzureNative.Migrate.Inputs.VmUptimeArgs
 *             {
 *                 DaysPerMonth = 31,
 *                 HoursPerDay = 24,
 *             },
 *         },
 *         ResourceGroupName = "abgoyal-westEurope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAssessment(ctx, "assessment", &migrate.AssessmentArgs{
 * 			AssessmentName: pulumi.String("assessment_5_14_2019_16_48_47"),
 * 			ETag:           pulumi.String("\"1e000c2c-0000-0d00-0000-5cdaa4190000\""),
 * 			GroupName:      pulumi.String("Group2"),
 * 			ProjectName:    pulumi.String("abgoyalWEselfhostb72bproject"),
 * 			Properties: migrate.AssessmentPropertiesResponse{
 * 				AzureDiskType:          pulumi.String("StandardOrPremium"),
 * 				AzureHybridUseBenefit:  pulumi.String("Yes"),
 * 				AzureLocation:          pulumi.String("NorthEurope"),
 * 				AzureOfferCode:         pulumi.String("MSAZR0003P"),
 * 				AzurePricingTier:       pulumi.String("Standard"),
 * 				AzureStorageRedundancy: pulumi.String("LocallyRedundant"),
 * 				AzureVmFamilies: pulumi.StringArray{
 * 					pulumi.String("Dv2_series"),
 * 					pulumi.String("F_series"),
 * 					pulumi.String("Dv3_series"),
 * 					pulumi.String("DS_series"),
 * 					pulumi.String("DSv2_series"),
 * 					pulumi.String("Fs_series"),
 * 					pulumi.String("Dsv3_series"),
 * 					pulumi.String("Ev3_series"),
 * 					pulumi.String("Esv3_series"),
 * 					pulumi.String("D_series"),
 * 					pulumi.String("M_series"),
 * 					pulumi.String("Fsv2_series"),
 * 					pulumi.String("H_series"),
 * 				},
 * 				Currency:           pulumi.String("USD"),
 * 				DiscountPercentage: pulumi.Float64(100),
 * 				Percentile:         pulumi.String("Percentile95"),
 * 				ReservedInstance:   pulumi.String("RI3Year"),
 * 				ScalingFactor:      pulumi.Float64(1),
 * 				SizingCriterion:    pulumi.String("PerformanceBased"),
 * 				Stage:              pulumi.String("InProgress"),
 * 				TimeRange:          pulumi.String("Day"),
 * 				VmUptime: &migrate.VmUptimeArgs{
 * 					DaysPerMonth: pulumi.Float64(31),
 * 					HoursPerDay:  pulumi.Float64(24),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.Assessment;
 * import com.pulumi.azurenative.migrate.AssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessment = new Assessment("assessment", AssessmentArgs.builder()
 *             .assessmentName("assessment_5_14_2019_16_48_47")
 *             .eTag("\"1e000c2c-0000-0d00-0000-5cdaa4190000\"")
 *             .groupName("Group2")
 *             .projectName("abgoyalWEselfhostb72bproject")
 *             .properties(Map.ofEntries(
 *                 Map.entry("azureDiskType", "StandardOrPremium"),
 *                 Map.entry("azureHybridUseBenefit", "Yes"),
 *                 Map.entry("azureLocation", "NorthEurope"),
 *                 Map.entry("azureOfferCode", "MSAZR0003P"),
 *                 Map.entry("azurePricingTier", "Standard"),
 *                 Map.entry("azureStorageRedundancy", "LocallyRedundant"),
 *                 Map.entry("azureVmFamilies",
 *                     "Dv2_series",
 *                     "F_series",
 *                     "Dv3_series",
 *                     "DS_series",
 *                     "DSv2_series",
 *                     "Fs_series",
 *                     "Dsv3_series",
 *                     "Ev3_series",
 *                     "Esv3_series",
 *                     "D_series",
 *                     "M_series",
 *                     "Fsv2_series",
 *                     "H_series"),
 *                 Map.entry("currency", "USD"),
 *                 Map.entry("discountPercentage", 100),
 *                 Map.entry("percentile", "Percentile95"),
 *                 Map.entry("reservedInstance", "RI3Year"),
 *                 Map.entry("scalingFactor", 1),
 *                 Map.entry("sizingCriterion", "PerformanceBased"),
 *                 Map.entry("stage", "InProgress"),
 *                 Map.entry("timeRange", "Day"),
 *                 Map.entry("vmUptime", Map.ofEntries(
 *                     Map.entry("daysPerMonth", 31),
 *                     Map.entry("hoursPerDay", 24)
 *                 ))
 *             ))
 *             .resourceGroupName("abgoyal-westEurope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:Assessment assessment_5_14_2019_16_48_47 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}
 * ```
 * @property assessmentName Unique name of an assessment within a project.
 * @property eTag For optimistic concurrency control.
 * @property groupName Unique name of a group within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property properties Properties of the assessment.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class AssessmentArgs(
    public val assessmentName: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<AssessmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.AssessmentArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.AssessmentArgs =
        com.pulumi.azurenative.migrate.AssessmentArgs.builder()
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentArgs].
 */
@PulumiTagMarker
public class AssessmentArgsBuilder internal constructor() {
    private var assessmentName: Output<String>? = null

    private var eTag: Output<String>? = null

    private var groupName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<AssessmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Unique name of an assessment within a project.
     */
    @JvmName("tlpblbhbqawhxnpj")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("fhcbqwlvcqjcrkay")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Unique name of a group within a project.
     */
    @JvmName("dbdqgomymtmcmffi")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("uibatqatfbdkvitk")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Properties of the assessment.
     */
    @JvmName("qflhtaveyipopdcl")
    public suspend fun properties(`value`: Output<AssessmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("hdhqcsmkypkunidb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Unique name of an assessment within a project.
     */
    @JvmName("bvrbgmmrqibexyhy")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("cwvhudfoiowrtnna")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Unique name of a group within a project.
     */
    @JvmName("tphbewtghxmnpciy")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("xrsvslnmpycnbifc")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Properties of the assessment.
     */
    @JvmName("lbydirhsmhvtolmu")
    public suspend fun properties(`value`: AssessmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the assessment.
     */
    @JvmName("yiqlyuvlkahrtqlt")
    public suspend fun properties(argument: suspend AssessmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("cljubofhpxptsosa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AssessmentArgs = AssessmentArgs(
        assessmentName = assessmentName,
        eTag = eTag,
        groupName = groupName,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
