@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.ReportDetailsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SettingsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.migrate.kotlin.outputs.ReportDetailsResponse.Companion.toKotlin as reportDetailsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SettingsResponse.Companion.toKotlin as settingsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BusinessCaseOperation].
 */
@PulumiTagMarker
public class BusinessCaseOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BusinessCaseOperationArgs = BusinessCaseOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BusinessCaseOperationArgsBuilder.() -> Unit) {
        val builder = BusinessCaseOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BusinessCaseOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.BusinessCaseOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BusinessCaseOperation(builtJavaResource)
    }
}

/**
 * Business case resource.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### BusinessCaseOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var businessCaseOperation = new AzureNative.Migrate.BusinessCaseOperation("businessCaseOperation", new()
 *     {
 *         BusinessCaseName = "sample-business-case",
 *         ProjectName = "multipleto8617project",
 *         ResourceGroupName = "rgopenapi",
 *         Settings = new AzureNative.Migrate.Inputs.SettingsArgs
 *         {
 *             AzureSettings = new AzureNative.Migrate.Inputs.AzureSettingsArgs
 *             {
 *                 AvsLaborCostPercentage = 0,
 *                 BusinessCaseType = "OptimizeForCost",
 *                 ComfortFactor = 29,
 *                 Currency = "USD",
 *                 DiscountPercentage = 83,
 *                 IaasLaborCostPercentage = 94,
 *                 InfrastructureGrowthRate = 83,
 *                 NetworkCostPercentage = 40,
 *                 PaasLaborCostPercentage = 47,
 *                 PerYearMigrationCompletionPercentage =
 *                 {
 *                     { "Year0", 20 },
 *                     { "Year1", 30 },
 *                     { "Year2", 60 },
 *                     { "Year3", 90 },
 *                 },
 *                 PerformanceDataEndTime = "2023-11-08T07:10:07.764Z",
 *                 PerformanceDataStartTime = "2023-11-08T07:10:07.764Z",
 *                 PerformanceUtilizationPercentile = 4,
 *                 SavingsOption = "RI3Year",
 *                 TargetLocation = "WestUs2",
 *                 Wacc = 79,
 *                 WorkloadDiscoverySource = "Appliance",
 *             },
 *             OnPremiseSettings = new AzureNative.Migrate.Inputs.OnPremiseSettingsArgs
 *             {
 *                 ComputeSettings = new AzureNative.Migrate.Inputs.ComputeSettingsArgs
 *                 {
 *                     HyperthreadCoreToMemoryRatio = 12,
 *                     Price = 16,
 *                     SqlServerLicensing = new[]
 *                     {
 *                         new AzureNative.Migrate.Inputs.SqlServerLicensingSettingsArgs
 *                         {
 *                             LicenseCost = 27,
 *                             SoftwareAssuranceCost = 16,
 *                             Version = "Enterprise",
 *                         },
 *                     },
 *                     VirtualizationSoftwareSettings = new AzureNative.Migrate.Inputs.VirtualizationSoftwareSettingsArgs
 *                     {
 *                         LicenseAndSupportList = new[]
 *                         {
 *                             new AzureNative.Migrate.Inputs.VsphereLicenseArgs
 *                             {
 *                                 BasicSupportCost = 22,
 *                                 LicenseCost = 8,
 *                                 LicenseType = "VSphereStandard",
 *                                 ProductionSupportCost = 22,
 *                             },
 *                         },
 *                         NumberOfPhysicalCoresPerLicense = 17,
 *                         SoftwareAssuranceCost = 14,
 *                     },
 *                     WindowsServerLicensing = new AzureNative.Migrate.Inputs.WindowsServerLicensingSettingsArgs
 *                     {
 *                         LicenseCost = 9,
 *                         LicensesPerCore = 11,
 *                         SoftwareAssuranceCost = 1,
 *                     },
 *                 },
 *                 FacilitySettings = new AzureNative.Migrate.Inputs.FacilitySettingsArgs
 *                 {
 *                     FacilitiesCost = 7,
 *                 },
 *                 LaborSettings = new AzureNative.Migrate.Inputs.LaborSettingsArgs
 *                 {
 *                     HourlyAdminCost = 25,
 *                     PhysicalServersPerAdmin = 6,
 *                     VirtualMachinesPerAdmin = 24,
 *                 },
 *                 ManagementSettings = new AzureNative.Migrate.Inputs.ManagementSettingsArgs
 *                 {
 *                     HypervVirtualizationManagementSettings = new AzureNative.Migrate.Inputs.HypervVirtualizationManagementSettingsArgs
 *                     {
 *                         LicenseAndSupportList = new[]
 *                         {
 *                             new AzureNative.Migrate.Inputs.HypervLicenseArgs
 *                             {
 *                                 LicenseCost = 4,
 *                                 LicenseType = "Standard",
 *                             },
 *                         },
 *                         NumberOfPhysicalCoresPerLicense = 2,
 *                         SoftwareAssuranceCost = 11,
 *                     },
 *                     OtherManagementCostsSettings = new AzureNative.Migrate.Inputs.OtherManagementCostsSettingsArgs
 *                     {
 *                         DataProtectionCostPerServerPerYear = 18,
 *                         MonitoringCostPerServerPerYear = 10,
 *                         PatchingCostPerServerPerYear = 18,
 *                     },
 *                     ThirdPartyManagementSettings = new AzureNative.Migrate.Inputs.ThirdPartyManagementSettingsArgs
 *                     {
 *                         LicenseCost = 23,
 *                         SupportCost = 9,
 *                     },
 *                     VsphereManagementSettings = new AzureNative.Migrate.Inputs.VsphereManagementSettingsArgs
 *                     {
 *                         LicenseAndSupportList = new[]
 *                         {
 *                             new AzureNative.Migrate.Inputs.VsphereManagementLicenseArgs
 *                             {
 *                                 BasicSupportCost = 1,
 *                                 LicenseCost = 6,
 *                                 LicenseType = "VSphereServerStandard",
 *                                 ProductionSupportCost = 18,
 *                             },
 *                         },
 *                     },
 *                 },
 *                 NetworkSettings = new AzureNative.Migrate.Inputs.NetworkSettingsArgs
 *                 {
 *                     HardwareSoftwareCostPercentage = 50,
 *                     MaintenanceCostPercentage = 48,
 *                 },
 *                 SecuritySettings = new AzureNative.Migrate.Inputs.SecuritySettingsArgs
 *                 {
 *                     ServerSecurityCostPerServerPerYear = 14,
 *                     SqlServerSecurityCostPerServerPerYear = 7,
 *                 },
 *                 StorageSettings = new AzureNative.Migrate.Inputs.StorageSettingsArgs
 *                 {
 *                     CostPerGbPerMonth = 22,
 *                     MaintainanceCostPercentageToAcquisitionCost = 1,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewBusinessCaseOperation(ctx, "businessCaseOperation", &migrate.BusinessCaseOperationArgs{
 * BusinessCaseName: pulumi.String("sample-business-case"),
 * ProjectName: pulumi.String("multipleto8617project"),
 * ResourceGroupName: pulumi.String("rgopenapi"),
 * Settings: migrate.SettingsResponse{
 * AzureSettings: &migrate.AzureSettingsArgs{
 * AvsLaborCostPercentage: pulumi.Float64(0),
 * BusinessCaseType: pulumi.String("OptimizeForCost"),
 * ComfortFactor: pulumi.Float64(29),
 * Currency: pulumi.String("USD"),
 * DiscountPercentage: pulumi.Float64(83),
 * IaasLaborCostPercentage: pulumi.Float64(94),
 * InfrastructureGrowthRate: pulumi.Float64(83),
 * NetworkCostPercentage: pulumi.Float64(40),
 * PaasLaborCostPercentage: pulumi.Float64(47),
 * PerYearMigrationCompletionPercentage: pulumi.Float64Map{
 * "Year0": pulumi.Float64(20),
 * "Year1": pulumi.Float64(30),
 * "Year2": pulumi.Float64(60),
 * "Year3": pulumi.Float64(90),
 * },
 * PerformanceDataEndTime: pulumi.String("2023-11-08T07:10:07.764Z"),
 * PerformanceDataStartTime: pulumi.String("2023-11-08T07:10:07.764Z"),
 * PerformanceUtilizationPercentile: pulumi.Float64(4),
 * SavingsOption: pulumi.String("RI3Year"),
 * TargetLocation: pulumi.String("WestUs2"),
 * Wacc: pulumi.Float64(79),
 * WorkloadDiscoverySource: pulumi.String("Appliance"),
 * },
 * OnPremiseSettings: interface{}{
 * ComputeSettings: interface{}{
 * HyperthreadCoreToMemoryRatio: pulumi.Float64(12),
 * Price: pulumi.Float64(16),
 * SqlServerLicensing: migrate.SqlServerLicensingSettingsArray{
 * &migrate.SqlServerLicensingSettingsArgs{
 * LicenseCost: pulumi.Float64(27),
 * SoftwareAssuranceCost: pulumi.Float64(16),
 * Version: pulumi.String("Enterprise"),
 * },
 * },
 * VirtualizationSoftwareSettings: interface{}{
 * LicenseAndSupportList: migrate.VsphereLicenseArray{
 * &migrate.VsphereLicenseArgs{
 * BasicSupportCost: pulumi.Float64(22),
 * LicenseCost: pulumi.Float64(8),
 * LicenseType: pulumi.String("VSphereStandard"),
 * ProductionSupportCost: pulumi.Float64(22),
 * },
 * },
 * NumberOfPhysicalCoresPerLicense: pulumi.Int(17),
 * SoftwareAssuranceCost: pulumi.Float64(14),
 * },
 * WindowsServerLicensing: &migrate.WindowsServerLicensingSettingsArgs{
 * LicenseCost: pulumi.Float64(9),
 * LicensesPerCore: pulumi.Int(11),
 * SoftwareAssuranceCost: pulumi.Float64(1),
 * },
 * },
 * FacilitySettings: &migrate.FacilitySettingsArgs{
 * FacilitiesCost: pulumi.Float64(7),
 * },
 * LaborSettings: &migrate.LaborSettingsArgs{
 * HourlyAdminCost: pulumi.Float64(25),
 * PhysicalServersPerAdmin: pulumi.Int(6),
 * VirtualMachinesPerAdmin: pulumi.Int(24),
 * },
 * ManagementSettings: interface{}{
 * HypervVirtualizationManagementSettings: interface{}{
 * LicenseAndSupportList: migrate.HypervLicenseArray{
 * &migrate.HypervLicenseArgs{
 * LicenseCost: pulumi.Float64(4),
 * LicenseType: pulumi.String("Standard"),
 * },
 * },
 * NumberOfPhysicalCoresPerLicense: pulumi.Int(2),
 * SoftwareAssuranceCost: pulumi.Float64(11),
 * },
 * OtherManagementCostsSettings: &migrate.OtherManagementCostsSettingsArgs{
 * DataProtectionCostPerServerPerYear: pulumi.Float64(18),
 * MonitoringCostPerServerPerYear: pulumi.Float64(10),
 * PatchingCostPerServerPerYear: pulumi.Float64(18),
 * },
 * ThirdPartyManagementSettings: &migrate.ThirdPartyManagementSettingsArgs{
 * LicenseCost: pulumi.Float64(23),
 * SupportCost: pulumi.Float64(9),
 * },
 * VsphereManagementSettings: interface{}{
 * LicenseAndSupportList: migrate.VsphereManagementLicenseArray{
 * &migrate.VsphereManagementLicenseArgs{
 * BasicSupportCost: pulumi.Float64(1),
 * LicenseCost: pulumi.Float64(6),
 * LicenseType: pulumi.String("VSphereServerStandard"),
 * ProductionSupportCost: pulumi.Float64(18),
 * },
 * },
 * },
 * },
 * NetworkSettings: &migrate.NetworkSettingsArgs{
 * HardwareSoftwareCostPercentage: pulumi.Float64(50),
 * MaintenanceCostPercentage: pulumi.Float64(48),
 * },
 * SecuritySettings: &migrate.SecuritySettingsArgs{
 * ServerSecurityCostPerServerPerYear: pulumi.Float64(14),
 * SqlServerSecurityCostPerServerPerYear: pulumi.Float64(7),
 * },
 * StorageSettings: &migrate.StorageSettingsArgs{
 * CostPerGbPerMonth: pulumi.Float64(22),
 * MaintainanceCostPercentageToAcquisitionCost: pulumi.Float64(1),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.BusinessCaseOperation;
 * import com.pulumi.azurenative.migrate.BusinessCaseOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var businessCaseOperation = new BusinessCaseOperation("businessCaseOperation", BusinessCaseOperationArgs.builder()
 *             .businessCaseName("sample-business-case")
 *             .projectName("multipleto8617project")
 *             .resourceGroupName("rgopenapi")
 *             .settings(Map.ofEntries(
 *                 Map.entry("azureSettings", Map.ofEntries(
 *                     Map.entry("avsLaborCostPercentage", 0),
 *                     Map.entry("businessCaseType", "OptimizeForCost"),
 *                     Map.entry("comfortFactor", 29),
 *                     Map.entry("currency", "USD"),
 *                     Map.entry("discountPercentage", 83),
 *                     Map.entry("iaasLaborCostPercentage", 94),
 *                     Map.entry("infrastructureGrowthRate", 83),
 *                     Map.entry("networkCostPercentage", 40),
 *                     Map.entry("paasLaborCostPercentage", 47),
 *                     Map.entry("perYearMigrationCompletionPercentage", Map.ofEntries(
 *                         Map.entry("Year0", 20),
 *                         Map.entry("Year1", 30),
 *                         Map.entry("Year2", 60),
 *                         Map.entry("Year3", 90)
 *                     )),
 *                     Map.entry("performanceDataEndTime", "2023-11-08T07:10:07.764Z"),
 *                     Map.entry("performanceDataStartTime", "2023-11-08T07:10:07.764Z"),
 *                     Map.entry("performanceUtilizationPercentile", 4),
 *                     Map.entry("savingsOption", "RI3Year"),
 *                     Map.entry("targetLocation", "WestUs2"),
 *                     Map.entry("wacc", 79),
 *                     Map.entry("workloadDiscoverySource", "Appliance")
 *                 )),
 *                 Map.entry("onPremiseSettings", Map.ofEntries(
 *                     Map.entry("computeSettings", Map.ofEntries(
 *                         Map.entry("hyperthreadCoreToMemoryRatio", 12),
 *                         Map.entry("price", 16),
 *                         Map.entry("sqlServerLicensing", Map.ofEntries(
 *                             Map.entry("licenseCost", 27),
 *                             Map.entry("softwareAssuranceCost", 16),
 *                             Map.entry("version", "Enterprise")
 *                         )),
 *                         Map.entry("virtualizationSoftwareSettings", Map.ofEntries(
 *                             Map.entry("licenseAndSupportList", Map.ofEntries(
 *                                 Map.entry("basicSupportCost", 22),
 *                                 Map.entry("licenseCost", 8),
 *                                 Map.entry("licenseType", "VSphereStandard"),
 *                                 Map.entry("productionSupportCost", 22)
 *                             )),
 *                             Map.entry("numberOfPhysicalCoresPerLicense", 17),
 *                             Map.entry("softwareAssuranceCost", 14)
 *                         )),
 *                         Map.entry("windowsServerLicensing", Map.ofEntries(
 *                             Map.entry("licenseCost", 9),
 *                             Map.entry("licensesPerCore", 11),
 *                             Map.entry("softwareAssuranceCost", 1)
 *                         ))
 *                     )),
 *                     Map.entry("facilitySettings", Map.of("facilitiesCost", 7)),
 *                     Map.entry("laborSettings", Map.ofEntries(
 *                         Map.entry("hourlyAdminCost", 25),
 *                         Map.entry("physicalServersPerAdmin", 6),
 *                         Map.entry("virtualMachinesPerAdmin", 24)
 *                     )),
 *                     Map.entry("managementSettings", Map.ofEntries(
 *                         Map.entry("hypervVirtualizationManagementSettings", Map.ofEntries(
 *                             Map.entry("licenseAndSupportList", Map.ofEntries(
 *                                 Map.entry("licenseCost", 4),
 *                                 Map.entry("licenseType", "Standard")
 *                             )),
 *                             Map.entry("numberOfPhysicalCoresPerLicense", 2),
 *                             Map.entry("softwareAssuranceCost", 11)
 *                         )),
 *                         Map.entry("otherManagementCostsSettings", Map.ofEntries(
 *                             Map.entry("dataProtectionCostPerServerPerYear", 18),
 *                             Map.entry("monitoringCostPerServerPerYear", 10),
 *                             Map.entry("patchingCostPerServerPerYear", 18)
 *                         )),
 *                         Map.entry("thirdPartyManagementSettings", Map.ofEntries(
 *                             Map.entry("licenseCost", 23),
 *                             Map.entry("supportCost", 9)
 *                         )),
 *                         Map.entry("vsphereManagementSettings", Map.of("licenseAndSupportList", Map.ofEntries(
 *                             Map.entry("basicSupportCost", 1),
 *                             Map.entry("licenseCost", 6),
 *                             Map.entry("licenseType", "VSphereServerStandard"),
 *                             Map.entry("productionSupportCost", 18)
 *                         )))
 *                     )),
 *                     Map.entry("networkSettings", Map.ofEntries(
 *                         Map.entry("hardwareSoftwareCostPercentage", 50),
 *                         Map.entry("maintenanceCostPercentage", 48)
 *                     )),
 *                     Map.entry("securitySettings", Map.ofEntries(
 *                         Map.entry("serverSecurityCostPerServerPerYear", 14),
 *                         Map.entry("sqlServerSecurityCostPerServerPerYear", 7)
 *                     )),
 *                     Map.entry("storageSettings", Map.ofEntries(
 *                         Map.entry("costPerGbPerMonth", 22),
 *                         Map.entry("maintainanceCostPercentageToAcquisitionCost", 1)
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:BusinessCaseOperation sample-business-case /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/businessCases/{businessCaseName}
 * ```
 */
public class BusinessCaseOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.BusinessCaseOperation,
) : KotlinCustomResource(javaResource, BusinessCaseOperationMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets the state of business case reports.
     */
    public val reportStatusDetails: Output<List<ReportDetailsResponse>>
        get() = javaResource.reportStatusDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> reportDetailsResponseToKotlin(args0) })
            })
        })

    /**
     * Business case settings.
     */
    public val settings: Output<SettingsResponse>?
        get() = javaResource.settings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    settingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Business case state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BusinessCaseOperationMapper : ResourceMapper<BusinessCaseOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.BusinessCaseOperation::class == javaResource::class

    override fun map(javaResource: Resource): BusinessCaseOperation =
        BusinessCaseOperation(javaResource as com.pulumi.azurenative.migrate.BusinessCaseOperation)
}

/**
 * @see [BusinessCaseOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BusinessCaseOperation].
 */
public suspend fun businessCaseOperation(
    name: String,
    block: suspend BusinessCaseOperationResourceBuilder.() -> Unit,
): BusinessCaseOperation {
    val builder = BusinessCaseOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BusinessCaseOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun businessCaseOperation(name: String): BusinessCaseOperation {
    val builder = BusinessCaseOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
