@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.GroupArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.GroupPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GroupPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A group created in a Migration project.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2018-02-02.
 * ## Example Usage
 * ### Groups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @group = new AzureNative.Migrate.Group("group", new()
 *     {
 *         ETag = "\"1e000c2c-0000-0d00-0000-5cdaa4190000\"",
 *         GroupName = "Group2",
 *         ProjectName = "abgoyalWEselfhostb72bproject",
 *         Properties = null,
 *         ResourceGroupName = "abgoyal-westEurope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewGroup(ctx, "group", &migrate.GroupArgs{
 * 			ETag:              pulumi.String("\"1e000c2c-0000-0d00-0000-5cdaa4190000\""),
 * 			GroupName:         pulumi.String("Group2"),
 * 			ProjectName:       pulumi.String("abgoyalWEselfhostb72bproject"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.Group;
 * import com.pulumi.azurenative.migrate.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var group = new Group("group", GroupArgs.builder()
 *             .eTag("\"1e000c2c-0000-0d00-0000-5cdaa4190000\"")
 *             .groupName("Group2")
 *             .projectName("abgoyalWEselfhostb72bproject")
 *             .properties()
 *             .resourceGroupName("abgoyal-westEurope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:Group Group2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}
 * ```
 * @property eTag For optimistic concurrency control.
 * @property groupName Unique name of a group within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property properties Properties of the group.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GroupArgs(
    public val eTag: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<GroupPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.GroupArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.GroupArgs =
        com.pulumi.azurenative.migrate.GroupArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var groupName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<GroupPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("qqgsxosjuggwcpso")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Unique name of a group within a project.
     */
    @JvmName("ievveqmefhemsejl")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("ghhpheigeamwykjn")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Properties of the group.
     */
    @JvmName("suykekgxondcpmti")
    public suspend fun properties(`value`: Output<GroupPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("mpahbtcfdevuijna")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("rffefehimkmdiivx")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Unique name of a group within a project.
     */
    @JvmName("fmlngdyqjpjxotux")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("qwbpvqsydrxymvfl")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Properties of the group.
     */
    @JvmName("egtfwwimndkecgap")
    public suspend fun properties(`value`: GroupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the group.
     */
    @JvmName("crhugxdohcfccgmx")
    public suspend fun properties(argument: suspend GroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GroupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("uupocwafcyuyymgd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        eTag = eTag,
        groupName = groupName,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
