@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GroupsOperation].
 */
@PulumiTagMarker
public class GroupsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupsOperationArgs = GroupsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupsOperationArgsBuilder.() -> Unit) {
        val builder = GroupsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GroupsOperation {
        val builtJavaResource = com.pulumi.azurenative.migrate.GroupsOperation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupsOperation(builtJavaResource)
    }
}

/**
 * Group resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### GroupsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groupsOperation = new AzureNative.Migrate.GroupsOperation("groupsOperation", new()
 *     {
 *         GroupName = "kuchatur-test",
 *         GroupType = "Default",
 *         ProjectName = "app18700project",
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "ayagrawrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewGroupsOperation(ctx, "groupsOperation", &migrate.GroupsOperationArgs{
 * 			GroupName:         pulumi.String("kuchatur-test"),
 * 			GroupType:         pulumi.String("Default"),
 * 			ProjectName:       pulumi.String("app18700project"),
 * 			ProvisioningState: pulumi.String("Succeeded"),
 * 			ResourceGroupName: pulumi.String("ayagrawrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.GroupsOperation;
 * import com.pulumi.azurenative.migrate.GroupsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groupsOperation = new GroupsOperation("groupsOperation", GroupsOperationArgs.builder()
 *             .groupName("kuchatur-test")
 *             .groupType("Default")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:GroupsOperation kuchatur-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}
 * ```
 */
public class GroupsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.GroupsOperation,
) : KotlinCustomResource(javaResource, GroupsOperationMapper) {
    /**
     * If the assessments are in running state.
     */
    public val areAssessmentsRunning: Output<Boolean>
        get() = javaResource.areAssessmentsRunning().applyValue({ args0 -> args0 })

    /**
     * List of References to Assessments created on this group.
     */
    public val assessments: Output<List<String>>
        get() = javaResource.assessments().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Time when this group was created. Date-Time represented in ISO-8601 format.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Whether the group has been created and is valid.
     */
    public val groupStatus: Output<String>
        get() = javaResource.groupStatus().applyValue({ args0 -> args0 })

    /**
     * The type of group.
     */
    public val groupType: Output<String>?
        get() = javaResource.groupType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Number of machines part of this group.
     */
    public val machineCount: Output<Int>
        get() = javaResource.machineCount().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of assessment types supported on this group.
     */
    public val supportedAssessmentTypes: Output<List<String>>?
        get() = javaResource.supportedAssessmentTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Time when this group was last updated. Date-Time represented in ISO-8601 format.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object GroupsOperationMapper : ResourceMapper<GroupsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.GroupsOperation::class == javaResource::class

    override fun map(javaResource: Resource): GroupsOperation = GroupsOperation(
        javaResource as
            com.pulumi.azurenative.migrate.GroupsOperation,
    )
}

/**
 * @see [GroupsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupsOperation].
 */
public suspend fun groupsOperation(
    name: String,
    block: suspend GroupsOperationResourceBuilder.() -> Unit,
): GroupsOperation {
    val builder = GroupsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupsOperation(name: String): GroupsOperation {
    val builder = GroupsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
