@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ImportCollectorsOperation].
 */
@PulumiTagMarker
public class ImportCollectorsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImportCollectorsOperationArgs = ImportCollectorsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImportCollectorsOperationArgsBuilder.() -> Unit) {
        val builder = ImportCollectorsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ImportCollectorsOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.ImportCollectorsOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ImportCollectorsOperation(builtJavaResource)
    }
}

/**
 * Import collector resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### ImportCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importCollectorsOperation = new AzureNative.Migrate.ImportCollectorsOperation("importCollectorsOperation", new()
 *     {
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourcegroups/ayagrawRG/providers/microsoft.offazure/importsites/actualSEA37d4importSite",
 *         ImportCollectorName = "importCollectore7d5",
 *         ProjectName = "app18700project",
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "ayagrawRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewImportCollectorsOperation(ctx, "importCollectorsOperation", &migrate.ImportCollectorsOperationArgs{
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourcegroups/ayagrawRG/providers/microsoft.offazure/importsites/actualSEA37d4importSite"),
 * 			ImportCollectorName: pulumi.String("importCollectore7d5"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String("Succeeded"),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ImportCollectorsOperation;
 * import com.pulumi.azurenative.migrate.ImportCollectorsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importCollectorsOperation = new ImportCollectorsOperation("importCollectorsOperation", ImportCollectorsOperationArgs.builder()
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourcegroups/ayagrawRG/providers/microsoft.offazure/importsites/actualSEA37d4importSite")
 *             .importCollectorName("importCollectore7d5")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ImportCollectorsOperation importCollectore7d5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/importcollectors/{importCollectorName}
 * ```
 */
public class ImportCollectorsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.ImportCollectorsOperation,
) : KotlinCustomResource(javaResource, ImportCollectorsOperationMapper) {
    /**
     * Gets the Timestamp when collector was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the discovery site id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Timestamp when collector was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object ImportCollectorsOperationMapper : ResourceMapper<ImportCollectorsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.ImportCollectorsOperation::class == javaResource::class

    override fun map(javaResource: Resource): ImportCollectorsOperation =
        ImportCollectorsOperation(
            javaResource as
                com.pulumi.azurenative.migrate.ImportCollectorsOperation,
        )
}

/**
 * @see [ImportCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImportCollectorsOperation].
 */
public suspend fun importCollectorsOperation(
    name: String,
    block: suspend ImportCollectorsOperationResourceBuilder.() -> Unit,
): ImportCollectorsOperation {
    val builder = ImportCollectorsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImportCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun importCollectorsOperation(name: String): ImportCollectorsOperation {
    val builder = ImportCollectorsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
