@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.MigrateAgentArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateAgentModelPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateAgentModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MigrateAgent model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### MigrateAgent_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateAgent = new AzureNative.Migrate.MigrateAgent("migrateAgent", new()
 *     {
 *         AgentName = "l",
 *         ModernizeProjectName = "rq1yec",
 *         Properties = new AzureNative.Migrate.Inputs.MigrateAgentModelPropertiesArgs
 *         {
 *             AuthenticationIdentity = new AzureNative.Migrate.Inputs.IdentityModelArgs
 *             {
 *                 AadAuthority = "isbicanvfefdaci",
 *                 ApplicationId = "dibfqwjrnzikktkwe",
 *                 Audience = "yrfxszjhkczoyfi",
 *                 ObjectId = "xfhhdosr",
 *                 TenantId = "uwceuawplakwjswbvllffbsz",
 *             },
 *             CustomProperties = null,
 *             MachineId = "sihoniqzqfz",
 *             MachineName = "glhejppirkiamgxxro",
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key5560", "jgffrfcgjrm" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateAgent(ctx, "migrateAgent", &migrate.MigrateAgentArgs{
 * 			AgentName:            pulumi.String("l"),
 * 			ModernizeProjectName: pulumi.String("rq1yec"),
 * 			Properties: migrate.MigrateAgentModelPropertiesResponse{
 * 				AuthenticationIdentity: &migrate.IdentityModelArgs{
 * 					AadAuthority:  pulumi.String("isbicanvfefdaci"),
 * 					ApplicationId: pulumi.String("dibfqwjrnzikktkwe"),
 * 					Audience:      pulumi.String("yrfxszjhkczoyfi"),
 * 					ObjectId:      pulumi.String("xfhhdosr"),
 * 					TenantId:      pulumi.String("uwceuawplakwjswbvllffbsz"),
 * 				},
 * 				CustomProperties: nil,
 * 				MachineId:        pulumi.String("sihoniqzqfz"),
 * 				MachineName:      pulumi.String("glhejppirkiamgxxro"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * 			Tags: pulumi.StringMap{
 * 				"key5560": pulumi.String("jgffrfcgjrm"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateAgent;
 * import com.pulumi.azurenative.migrate.MigrateAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateAgent = new MigrateAgent("migrateAgent", MigrateAgentArgs.builder()
 *             .agentName("l")
 *             .modernizeProjectName("rq1yec")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationIdentity", Map.ofEntries(
 *                     Map.entry("aadAuthority", "isbicanvfefdaci"),
 *                     Map.entry("applicationId", "dibfqwjrnzikktkwe"),
 *                     Map.entry("audience", "yrfxszjhkczoyfi"),
 *                     Map.entry("objectId", "xfhhdosr"),
 *                     Map.entry("tenantId", "uwceuawplakwjswbvllffbsz")
 *                 )),
 *                 Map.entry("customProperties", ),
 *                 Map.entry("machineId", "sihoniqzqfz"),
 *                 Map.entry("machineName", "glhejppirkiamgxxro")
 *             ))
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key5560", "jgffrfcgjrm"))
 *             .build());
 *     }
 * }
 * ```
 * ### MigrateAgent_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateAgent = new AzureNative.Migrate.MigrateAgent("migrateAgent", new()
 *     {
 *         AgentName = "e85v",
 *         ModernizeProjectName = "l77ak",
 *         ResourceGroupName = "rgmigrateEngine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateAgent(ctx, "migrateAgent", &migrate.MigrateAgentArgs{
 * 			AgentName:            pulumi.String("e85v"),
 * 			ModernizeProjectName: pulumi.String("l77ak"),
 * 			ResourceGroupName:    pulumi.String("rgmigrateEngine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateAgent;
 * import com.pulumi.azurenative.migrate.MigrateAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateAgent = new MigrateAgent("migrateAgent", MigrateAgentArgs.builder()
 *             .agentName("e85v")
 *             .modernizeProjectName("l77ak")
 *             .resourceGroupName("rgmigrateEngine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MigrateAgent icysfvhjjgwhxx /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}/migrateAgents/{agentName}
 * ```
 * @property agentName MigrateAgent name.
 * @property modernizeProjectName ModernizeProject name.
 * @property properties MigrateAgent model properties.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 * @property tags Gets or sets the resource tags.
 */
public data class MigrateAgentArgs(
    public val agentName: Output<String>? = null,
    public val modernizeProjectName: Output<String>? = null,
    public val properties: Output<MigrateAgentModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.MigrateAgentArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.MigrateAgentArgs =
        com.pulumi.azurenative.migrate.MigrateAgentArgs.builder()
            .agentName(agentName?.applyValue({ args0 -> args0 }))
            .modernizeProjectName(modernizeProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MigrateAgentArgs].
 */
@PulumiTagMarker
public class MigrateAgentArgsBuilder internal constructor() {
    private var agentName: Output<String>? = null

    private var modernizeProjectName: Output<String>? = null

    private var properties: Output<MigrateAgentModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value MigrateAgent name.
     */
    @JvmName("dmapxokvbwlruwgm")
    public suspend fun agentName(`value`: Output<String>) {
        this.agentName = value
    }

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("bbowgukksuawnaex")
    public suspend fun modernizeProjectName(`value`: Output<String>) {
        this.modernizeProjectName = value
    }

    /**
     * @param value MigrateAgent model properties.
     */
    @JvmName("ouuecwrjikbaxioa")
    public suspend fun properties(`value`: Output<MigrateAgentModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("orsoqshtnahovvvr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("hirxavxtqfwiehet")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("wwssehdsihqnkqqc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value MigrateAgent name.
     */
    @JvmName("qmmktndlpolkocbk")
    public suspend fun agentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentName = mapped
    }

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("tonwyrjlgyylvcxh")
    public suspend fun modernizeProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value MigrateAgent model properties.
     */
    @JvmName("nlrdsiwwghveuayn")
    public suspend fun properties(`value`: MigrateAgentModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument MigrateAgent model properties.
     */
    @JvmName("yxnutkvwcbepjkxr")
    public suspend
    fun properties(argument: suspend MigrateAgentModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateAgentModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("lfonpieavyydujud")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("mwgsykqgakqqmtvf")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("qdcywnyhcnsjtjjh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the resource tags.
     */
    @JvmName("gbtqurwofciacrbt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MigrateAgentArgs = MigrateAgentArgs(
        agentName = agentName,
        modernizeProjectName = modernizeProjectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        tags = tags,
    )
}
