@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.MigrateFunctions.getAksAssessmentOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getAssessmentPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getAssessmentProjectsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getAssessmentsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getAvsAssessmentsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getBusinessCaseOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getBusinessCaseOperationReportDownloadUrlPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getGroupPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getGroupsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getHyperVCollectorPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getHypervCollectorsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getImportCollectorPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getImportCollectorsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getMigrateAgentPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getMigrateProjectPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getMigrateProjectsControllerMigrateProjectPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getModernizeProjectPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getMoveCollectionPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getMoveResourcePlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getPrivateEndpointConnectionControllerPrivateEndpointConnectionPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getPrivateEndpointConnectionOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getPrivateEndpointConnectionProxyControllerPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getProjectKeysPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getProjectPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getServerCollectorPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getServerCollectorsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getSolutionConfigPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getSolutionPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getSolutionsControllerConfigPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getSolutionsControllerSolutionPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getSqlAssessmentV2OperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getSqlCollectorOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getVMwareCollectorPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getVmwareCollectorsOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getWebAppAssessmentV2OperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getWebAppCollectorOperationPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getWorkloadDeploymentPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getWorkloadDeploymentSecretConfigurationsPlain
import com.pulumi.azurenative.migrate.MigrateFunctions.getWorkloadInstancePlain
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAksAssessmentOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAksAssessmentOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAssessmentPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAssessmentPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAssessmentProjectsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAssessmentProjectsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAssessmentsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAssessmentsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAvsAssessmentsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetAvsAssessmentsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetBusinessCaseOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetBusinessCaseOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetBusinessCaseOperationReportDownloadUrlPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetBusinessCaseOperationReportDownloadUrlPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetGroupsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetGroupsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetHyperVCollectorPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetHyperVCollectorPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetHypervCollectorsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetHypervCollectorsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetImportCollectorPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetImportCollectorPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetImportCollectorsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetImportCollectorsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMigrateAgentPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMigrateAgentPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMigrateProjectPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMigrateProjectPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMigrateProjectsControllerMigrateProjectPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMigrateProjectsControllerMigrateProjectPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetModernizeProjectPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetModernizeProjectPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMoveCollectionPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMoveCollectionPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMoveResourcePlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetMoveResourcePlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionProxyControllerPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetPrivateEndpointConnectionProxyControllerPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetProjectKeysPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetProjectKeysPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetProjectPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetProjectPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetServerCollectorPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetServerCollectorPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetServerCollectorsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetServerCollectorsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionConfigPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionConfigPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionsControllerConfigPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionsControllerConfigPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionsControllerSolutionPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSolutionsControllerSolutionPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSqlAssessmentV2OperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSqlAssessmentV2OperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSqlCollectorOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetSqlCollectorOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetVMwareCollectorPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetVMwareCollectorPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetVmwareCollectorsOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetVmwareCollectorsOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWebAppAssessmentV2OperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWebAppAssessmentV2OperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWebAppCollectorOperationPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWebAppCollectorOperationPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWorkloadDeploymentPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWorkloadDeploymentPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWorkloadDeploymentSecretConfigurationsPlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWorkloadDeploymentSecretConfigurationsPlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWorkloadInstancePlainArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.GetWorkloadInstancePlainArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAksAssessmentOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAssessmentProjectsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAssessmentResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAssessmentsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAvsAssessmentsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetBusinessCaseOperationReportDownloadUrlResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetBusinessCaseOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetGroupResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetGroupsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetHyperVCollectorResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetHypervCollectorsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetImportCollectorResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetImportCollectorsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMigrateAgentResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMigrateProjectResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMigrateProjectsControllerMigrateProjectResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetModernizeProjectResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMoveCollectionResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMoveResourceResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionProxyControllerResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetProjectKeysResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetProjectResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetServerCollectorResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetServerCollectorsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionConfigResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionsControllerConfigResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionsControllerSolutionResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSqlAssessmentV2OperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSqlCollectorOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetVMwareCollectorResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetVmwareCollectorsOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWebAppAssessmentV2OperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWebAppCollectorOperationResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWorkloadDeploymentResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWorkloadDeploymentSecretConfigurationsResult
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWorkloadInstanceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAksAssessmentOperationResult.Companion.toKotlin as getAksAssessmentOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAssessmentProjectsOperationResult.Companion.toKotlin as getAssessmentProjectsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAssessmentResult.Companion.toKotlin as getAssessmentResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAssessmentsOperationResult.Companion.toKotlin as getAssessmentsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetAvsAssessmentsOperationResult.Companion.toKotlin as getAvsAssessmentsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetBusinessCaseOperationReportDownloadUrlResult.Companion.toKotlin as getBusinessCaseOperationReportDownloadUrlResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetBusinessCaseOperationResult.Companion.toKotlin as getBusinessCaseOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetGroupsOperationResult.Companion.toKotlin as getGroupsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetHyperVCollectorResult.Companion.toKotlin as getHyperVCollectorResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetHypervCollectorsOperationResult.Companion.toKotlin as getHypervCollectorsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetImportCollectorResult.Companion.toKotlin as getImportCollectorResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetImportCollectorsOperationResult.Companion.toKotlin as getImportCollectorsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMigrateAgentResult.Companion.toKotlin as getMigrateAgentResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMigrateProjectResult.Companion.toKotlin as getMigrateProjectResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMigrateProjectsControllerMigrateProjectResult.Companion.toKotlin as getMigrateProjectsControllerMigrateProjectResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetModernizeProjectResult.Companion.toKotlin as getModernizeProjectResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMoveCollectionResult.Companion.toKotlin as getMoveCollectionResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetMoveResourceResult.Companion.toKotlin as getMoveResourceResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionControllerPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionOperationResult.Companion.toKotlin as getPrivateEndpointConnectionOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionProxyControllerResult.Companion.toKotlin as getPrivateEndpointConnectionProxyControllerResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetProjectKeysResult.Companion.toKotlin as getProjectKeysResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetProjectResult.Companion.toKotlin as getProjectResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetServerCollectorResult.Companion.toKotlin as getServerCollectorResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetServerCollectorsOperationResult.Companion.toKotlin as getServerCollectorsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionConfigResult.Companion.toKotlin as getSolutionConfigResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionResult.Companion.toKotlin as getSolutionResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionsControllerConfigResult.Companion.toKotlin as getSolutionsControllerConfigResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSolutionsControllerSolutionResult.Companion.toKotlin as getSolutionsControllerSolutionResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSqlAssessmentV2OperationResult.Companion.toKotlin as getSqlAssessmentV2OperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetSqlCollectorOperationResult.Companion.toKotlin as getSqlCollectorOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetVMwareCollectorResult.Companion.toKotlin as getVMwareCollectorResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetVmwareCollectorsOperationResult.Companion.toKotlin as getVmwareCollectorsOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWebAppAssessmentV2OperationResult.Companion.toKotlin as getWebAppAssessmentV2OperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWebAppCollectorOperationResult.Companion.toKotlin as getWebAppCollectorOperationResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWorkloadDeploymentResult.Companion.toKotlin as getWorkloadDeploymentResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWorkloadDeploymentSecretConfigurationsResult.Companion.toKotlin as getWorkloadDeploymentSecretConfigurationsResultToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.GetWorkloadInstanceResult.Companion.toKotlin as getWorkloadInstanceResultToKotlin

public object MigrateFunctions {
    /**
     * Get a AKSAssessment
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return ARM model of AKS Assessment.
     */
    public suspend fun getAksAssessmentOperation(argument: GetAksAssessmentOperationPlainArgs):
        GetAksAssessmentOperationResult =
        getAksAssessmentOperationResultToKotlin(getAksAssessmentOperationPlain(argument.toJava()).await())

    /**
     * @see [getAksAssessmentOperation].
     * @param assessmentName AKS Assessment Name.
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return ARM model of AKS Assessment.
     */
    public suspend fun getAksAssessmentOperation(
        assessmentName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetAksAssessmentOperationResult {
        val argument = GetAksAssessmentOperationPlainArgs(
            assessmentName = assessmentName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getAksAssessmentOperationResultToKotlin(getAksAssessmentOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAksAssessmentOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetAksAssessmentOperationPlainArgs].
     * @return ARM model of AKS Assessment.
     */
    public suspend
    fun getAksAssessmentOperation(argument: suspend GetAksAssessmentOperationPlainArgsBuilder.() -> Unit):
        GetAksAssessmentOperationResult {
        val builder = GetAksAssessmentOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAksAssessmentOperationResultToKotlin(getAksAssessmentOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an existing assessment with the specified name. Returns a json object of type 'assessment' as specified in Models section.
     * Azure REST API version: 2019-10-01.
     * Other available API versions: 2017-11-11-preview, 2018-02-02.
     * @param argument null
     * @return An assessment created for a group in the Migration project.
     */
    public suspend fun getAssessment(argument: GetAssessmentPlainArgs): GetAssessmentResult =
        getAssessmentResultToKotlin(getAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getAssessment].
     * @param assessmentName Unique name of an assessment within a project.
     * @param groupName Unique name of a group within a project.
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return An assessment created for a group in the Migration project.
     */
    public suspend fun getAssessment(
        assessmentName: String,
        groupName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetAssessmentResult {
        val argument = GetAssessmentPlainArgs(
            assessmentName = assessmentName,
            groupName = groupName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getAssessmentResultToKotlin(getAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetAssessmentPlainArgs].
     * @return An assessment created for a group in the Migration project.
     */
    public suspend fun getAssessment(argument: suspend GetAssessmentPlainArgsBuilder.() -> Unit):
        GetAssessmentResult {
        val builder = GetAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssessmentResultToKotlin(getAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a AssessmentProject
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return An Assessment project site resource.
     */
    public suspend
    fun getAssessmentProjectsOperation(argument: GetAssessmentProjectsOperationPlainArgs):
        GetAssessmentProjectsOperationResult =
        getAssessmentProjectsOperationResultToKotlin(getAssessmentProjectsOperationPlain(argument.toJava()).await())

    /**
     * @see [getAssessmentProjectsOperation].
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Assessment project site resource.
     */
    public suspend fun getAssessmentProjectsOperation(projectName: String, resourceGroupName: String):
        GetAssessmentProjectsOperationResult {
        val argument = GetAssessmentProjectsOperationPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getAssessmentProjectsOperationResultToKotlin(getAssessmentProjectsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssessmentProjectsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetAssessmentProjectsOperationPlainArgs].
     * @return An Assessment project site resource.
     */
    public suspend
    fun getAssessmentProjectsOperation(argument: suspend GetAssessmentProjectsOperationPlainArgsBuilder.() -> Unit):
        GetAssessmentProjectsOperationResult {
        val builder = GetAssessmentProjectsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssessmentProjectsOperationResultToKotlin(getAssessmentProjectsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Assessment
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-03-15.
     * @param argument null
     * @return Machine assessment resource.
     */
    public suspend fun getAssessmentsOperation(argument: GetAssessmentsOperationPlainArgs):
        GetAssessmentsOperationResult =
        getAssessmentsOperationResultToKotlin(getAssessmentsOperationPlain(argument.toJava()).await())

    /**
     * @see [getAssessmentsOperation].
     * @param assessmentName Machine Assessment ARM name
     * @param groupName Group ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Machine assessment resource.
     */
    public suspend fun getAssessmentsOperation(
        assessmentName: String,
        groupName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetAssessmentsOperationResult {
        val argument = GetAssessmentsOperationPlainArgs(
            assessmentName = assessmentName,
            groupName = groupName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getAssessmentsOperationResultToKotlin(getAssessmentsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssessmentsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetAssessmentsOperationPlainArgs].
     * @return Machine assessment resource.
     */
    public suspend
    fun getAssessmentsOperation(argument: suspend GetAssessmentsOperationPlainArgsBuilder.() -> Unit):
        GetAssessmentsOperationResult {
        val builder = GetAssessmentsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssessmentsOperationResultToKotlin(getAssessmentsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a AvsAssessment
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return AVS assessment resource.
     */
    public suspend fun getAvsAssessmentsOperation(argument: GetAvsAssessmentsOperationPlainArgs):
        GetAvsAssessmentsOperationResult =
        getAvsAssessmentsOperationResultToKotlin(getAvsAssessmentsOperationPlain(argument.toJava()).await())

    /**
     * @see [getAvsAssessmentsOperation].
     * @param assessmentName AVS Assessment ARM name
     * @param groupName Group ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return AVS assessment resource.
     */
    public suspend fun getAvsAssessmentsOperation(
        assessmentName: String,
        groupName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetAvsAssessmentsOperationResult {
        val argument = GetAvsAssessmentsOperationPlainArgs(
            assessmentName = assessmentName,
            groupName = groupName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getAvsAssessmentsOperationResultToKotlin(getAvsAssessmentsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAvsAssessmentsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetAvsAssessmentsOperationPlainArgs].
     * @return AVS assessment resource.
     */
    public suspend
    fun getAvsAssessmentsOperation(argument: suspend GetAvsAssessmentsOperationPlainArgsBuilder.() -> Unit):
        GetAvsAssessmentsOperationResult {
        val builder = GetAvsAssessmentsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvsAssessmentsOperationResultToKotlin(getAvsAssessmentsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a BusinessCase
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return Business case resource.
     */
    public suspend fun getBusinessCaseOperation(argument: GetBusinessCaseOperationPlainArgs):
        GetBusinessCaseOperationResult =
        getBusinessCaseOperationResultToKotlin(getBusinessCaseOperationPlain(argument.toJava()).await())

    /**
     * @see [getBusinessCaseOperation].
     * @param businessCaseName Business case ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Business case resource.
     */
    public suspend fun getBusinessCaseOperation(
        businessCaseName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetBusinessCaseOperationResult {
        val argument = GetBusinessCaseOperationPlainArgs(
            businessCaseName = businessCaseName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getBusinessCaseOperationResultToKotlin(getBusinessCaseOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getBusinessCaseOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetBusinessCaseOperationPlainArgs].
     * @return Business case resource.
     */
    public suspend
    fun getBusinessCaseOperation(argument: suspend GetBusinessCaseOperationPlainArgsBuilder.() -> Unit):
        GetBusinessCaseOperationResult {
        val builder = GetBusinessCaseOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBusinessCaseOperationResultToKotlin(getBusinessCaseOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the URL for downloading the business case in a report format.
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return Download URL for assessment report.
     */
    public suspend
    fun getBusinessCaseOperationReportDownloadUrl(argument: GetBusinessCaseOperationReportDownloadUrlPlainArgs):
        GetBusinessCaseOperationReportDownloadUrlResult =
        getBusinessCaseOperationReportDownloadUrlResultToKotlin(getBusinessCaseOperationReportDownloadUrlPlain(argument.toJava()).await())

    /**
     * @see [getBusinessCaseOperationReportDownloadUrl].
     * @param businessCaseName Business case ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Download URL for assessment report.
     */
    public suspend fun getBusinessCaseOperationReportDownloadUrl(
        businessCaseName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetBusinessCaseOperationReportDownloadUrlResult {
        val argument = GetBusinessCaseOperationReportDownloadUrlPlainArgs(
            businessCaseName = businessCaseName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getBusinessCaseOperationReportDownloadUrlResultToKotlin(getBusinessCaseOperationReportDownloadUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getBusinessCaseOperationReportDownloadUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetBusinessCaseOperationReportDownloadUrlPlainArgs].
     * @return Download URL for assessment report.
     */
    public suspend
    fun getBusinessCaseOperationReportDownloadUrl(argument: suspend GetBusinessCaseOperationReportDownloadUrlPlainArgsBuilder.() -> Unit):
        GetBusinessCaseOperationReportDownloadUrlResult {
        val builder = GetBusinessCaseOperationReportDownloadUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBusinessCaseOperationReportDownloadUrlResultToKotlin(getBusinessCaseOperationReportDownloadUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information related to a specific group in the project. Returns a json object of type 'group' as specified in the models section.
     * Azure REST API version: 2019-10-01.
     * Other available API versions: 2018-02-02.
     * @param argument null
     * @return A group created in a Migration project.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param groupName Unique name of a group within a project.
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return A group created in a Migration project.
     */
    public suspend fun getGroup(
        groupName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetGroupResult {
        val argument = GetGroupPlainArgs(
            groupName = groupName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return A group created in a Migration project.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit):
        GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Group
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return Group resource.
     */
    public suspend fun getGroupsOperation(argument: GetGroupsOperationPlainArgs):
        GetGroupsOperationResult =
        getGroupsOperationResultToKotlin(getGroupsOperationPlain(argument.toJava()).await())

    /**
     * @see [getGroupsOperation].
     * @param groupName Group ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Group resource.
     */
    public suspend fun getGroupsOperation(
        groupName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetGroupsOperationResult {
        val argument = GetGroupsOperationPlainArgs(
            groupName = groupName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getGroupsOperationResultToKotlin(getGroupsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetGroupsOperationPlainArgs].
     * @return Group resource.
     */
    public suspend
    fun getGroupsOperation(argument: suspend GetGroupsOperationPlainArgsBuilder.() -> Unit):
        GetGroupsOperationResult {
        val builder = GetGroupsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsOperationResultToKotlin(getGroupsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Hyper-V collector.
     * Azure REST API version: 2019-10-01.
     * @param argument null
     * @return null
     */
    public suspend fun getHyperVCollector(argument: GetHyperVCollectorPlainArgs):
        GetHyperVCollectorResult =
        getHyperVCollectorResultToKotlin(getHyperVCollectorPlain(argument.toJava()).await())

    /**
     * @see [getHyperVCollector].
     * @param hyperVCollectorName Unique name of a Hyper-V collector within a project.
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return null
     */
    public suspend fun getHyperVCollector(
        hyperVCollectorName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetHyperVCollectorResult {
        val argument = GetHyperVCollectorPlainArgs(
            hyperVCollectorName = hyperVCollectorName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getHyperVCollectorResultToKotlin(getHyperVCollectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getHyperVCollector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetHyperVCollectorPlainArgs].
     * @return null
     */
    public suspend
    fun getHyperVCollector(argument: suspend GetHyperVCollectorPlainArgsBuilder.() -> Unit):
        GetHyperVCollectorResult {
        val builder = GetHyperVCollectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHyperVCollectorResultToKotlin(getHyperVCollectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a HypervCollector
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return Hyper-V collector resource.
     */
    public suspend fun getHypervCollectorsOperation(argument: GetHypervCollectorsOperationPlainArgs):
        GetHypervCollectorsOperationResult =
        getHypervCollectorsOperationResultToKotlin(getHypervCollectorsOperationPlain(argument.toJava()).await())

    /**
     * @see [getHypervCollectorsOperation].
     * @param hypervCollectorName Hyper-V collector ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Hyper-V collector resource.
     */
    public suspend fun getHypervCollectorsOperation(
        hypervCollectorName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetHypervCollectorsOperationResult {
        val argument = GetHypervCollectorsOperationPlainArgs(
            hypervCollectorName = hypervCollectorName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getHypervCollectorsOperationResultToKotlin(getHypervCollectorsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getHypervCollectorsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetHypervCollectorsOperationPlainArgs].
     * @return Hyper-V collector resource.
     */
    public suspend
    fun getHypervCollectorsOperation(argument: suspend GetHypervCollectorsOperationPlainArgsBuilder.() -> Unit):
        GetHypervCollectorsOperationResult {
        val builder = GetHypervCollectorsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHypervCollectorsOperationResultToKotlin(getHypervCollectorsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Import collector.
     * Azure REST API version: 2019-10-01.
     * @param argument null
     * @return null
     */
    public suspend fun getImportCollector(argument: GetImportCollectorPlainArgs):
        GetImportCollectorResult =
        getImportCollectorResultToKotlin(getImportCollectorPlain(argument.toJava()).await())

    /**
     * @see [getImportCollector].
     * @param importCollectorName Unique name of a Import collector within a project.
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return null
     */
    public suspend fun getImportCollector(
        importCollectorName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetImportCollectorResult {
        val argument = GetImportCollectorPlainArgs(
            importCollectorName = importCollectorName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getImportCollectorResultToKotlin(getImportCollectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getImportCollector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetImportCollectorPlainArgs].
     * @return null
     */
    public suspend
    fun getImportCollector(argument: suspend GetImportCollectorPlainArgsBuilder.() -> Unit):
        GetImportCollectorResult {
        val builder = GetImportCollectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImportCollectorResultToKotlin(getImportCollectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ImportCollector
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return Import collector resource.
     */
    public suspend fun getImportCollectorsOperation(argument: GetImportCollectorsOperationPlainArgs):
        GetImportCollectorsOperationResult =
        getImportCollectorsOperationResultToKotlin(getImportCollectorsOperationPlain(argument.toJava()).await())

    /**
     * @see [getImportCollectorsOperation].
     * @param importCollectorName Import collector ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Import collector resource.
     */
    public suspend fun getImportCollectorsOperation(
        importCollectorName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetImportCollectorsOperationResult {
        val argument = GetImportCollectorsOperationPlainArgs(
            importCollectorName = importCollectorName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getImportCollectorsOperationResultToKotlin(getImportCollectorsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getImportCollectorsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetImportCollectorsOperationPlainArgs].
     * @return Import collector resource.
     */
    public suspend
    fun getImportCollectorsOperation(argument: suspend GetImportCollectorsOperationPlainArgsBuilder.() -> Unit):
        GetImportCollectorsOperationResult {
        val builder = GetImportCollectorsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImportCollectorsOperationResultToKotlin(getImportCollectorsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the modernizeProject agent.
     * Azure REST API version: 2022-05-01-preview.
     * @param argument null
     * @return MigrateAgent model.
     */
    public suspend fun getMigrateAgent(argument: GetMigrateAgentPlainArgs): GetMigrateAgentResult =
        getMigrateAgentResultToKotlin(getMigrateAgentPlain(argument.toJava()).await())

    /**
     * @see [getMigrateAgent].
     * @param agentName MigrateAgent name.
     * @param modernizeProjectName ModernizeProject name.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @param subscriptionId Azure Subscription Id in which project was created.
     * @return MigrateAgent model.
     */
    public suspend fun getMigrateAgent(
        agentName: String,
        modernizeProjectName: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
    ): GetMigrateAgentResult {
        val argument = GetMigrateAgentPlainArgs(
            agentName = agentName,
            modernizeProjectName = modernizeProjectName,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
        )
        return getMigrateAgentResultToKotlin(getMigrateAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getMigrateAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetMigrateAgentPlainArgs].
     * @return MigrateAgent model.
     */
    public suspend fun getMigrateAgent(argument: suspend GetMigrateAgentPlainArgsBuilder.() -> Unit):
        GetMigrateAgentResult {
        val builder = GetMigrateAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMigrateAgentResultToKotlin(getMigrateAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Migrate Project REST Resource.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return Migrate Project REST Resource.
     */
    public suspend fun getMigrateProject(argument: GetMigrateProjectPlainArgs):
        GetMigrateProjectResult =
        getMigrateProjectResultToKotlin(getMigrateProjectPlain(argument.toJava()).await())

    /**
     * @see [getMigrateProject].
     * @param migrateProjectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that migrate project is part of.
     * @return Migrate Project REST Resource.
     */
    public suspend fun getMigrateProject(migrateProjectName: String, resourceGroupName: String):
        GetMigrateProjectResult {
        val argument = GetMigrateProjectPlainArgs(
            migrateProjectName = migrateProjectName,
            resourceGroupName = resourceGroupName,
        )
        return getMigrateProjectResultToKotlin(getMigrateProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getMigrateProject].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetMigrateProjectPlainArgs].
     * @return Migrate Project REST Resource.
     */
    public suspend
    fun getMigrateProject(argument: suspend GetMigrateProjectPlainArgsBuilder.() -> Unit):
        GetMigrateProjectResult {
        val builder = GetMigrateProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMigrateProjectResultToKotlin(getMigrateProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information related to a specific migrate project. Returns a json object of type 'migrateProject' as specified in the models section.
     * Azure REST API version: 2020-05-01.
     * Other available API versions: 2023-01-01.
     * @param argument null
     * @return Migrate project.
     */
    public suspend
    fun getMigrateProjectsControllerMigrateProject(argument: GetMigrateProjectsControllerMigrateProjectPlainArgs):
        GetMigrateProjectsControllerMigrateProjectResult =
        getMigrateProjectsControllerMigrateProjectResultToKotlin(getMigrateProjectsControllerMigrateProjectPlain(argument.toJava()).await())

    /**
     * @see [getMigrateProjectsControllerMigrateProject].
     * @param migrateProjectName Migrate project name.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return Migrate project.
     */
    public suspend fun getMigrateProjectsControllerMigrateProject(
        migrateProjectName: String,
        resourceGroupName: String,
    ): GetMigrateProjectsControllerMigrateProjectResult {
        val argument = GetMigrateProjectsControllerMigrateProjectPlainArgs(
            migrateProjectName = migrateProjectName,
            resourceGroupName = resourceGroupName,
        )
        return getMigrateProjectsControllerMigrateProjectResultToKotlin(getMigrateProjectsControllerMigrateProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getMigrateProjectsControllerMigrateProject].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetMigrateProjectsControllerMigrateProjectPlainArgs].
     * @return Migrate project.
     */
    public suspend
    fun getMigrateProjectsControllerMigrateProject(argument: suspend GetMigrateProjectsControllerMigrateProjectPlainArgsBuilder.() -> Unit):
        GetMigrateProjectsControllerMigrateProjectResult {
        val builder = GetMigrateProjectsControllerMigrateProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMigrateProjectsControllerMigrateProjectResultToKotlin(getMigrateProjectsControllerMigrateProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the modernize project.
     * Azure REST API version: 2022-05-01-preview.
     * @param argument null
     * @return ModernizeProject model.
     */
    public suspend fun getModernizeProject(argument: GetModernizeProjectPlainArgs):
        GetModernizeProjectResult =
        getModernizeProjectResultToKotlin(getModernizeProjectPlain(argument.toJava()).await())

    /**
     * @see [getModernizeProject].
     * @param modernizeProjectName Modernize project name.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @param subscriptionId Azure Subscription Id in which project was created.
     * @return ModernizeProject model.
     */
    public suspend fun getModernizeProject(
        modernizeProjectName: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
    ): GetModernizeProjectResult {
        val argument = GetModernizeProjectPlainArgs(
            modernizeProjectName = modernizeProjectName,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
        )
        return getModernizeProjectResultToKotlin(getModernizeProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getModernizeProject].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetModernizeProjectPlainArgs].
     * @return ModernizeProject model.
     */
    public suspend
    fun getModernizeProject(argument: suspend GetModernizeProjectPlainArgsBuilder.() -> Unit):
        GetModernizeProjectResult {
        val builder = GetModernizeProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModernizeProjectResultToKotlin(getModernizeProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the move collection.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2023-08-01.
     * @param argument null
     * @return Define the move collection.
     */
    public suspend fun getMoveCollection(argument: GetMoveCollectionPlainArgs):
        GetMoveCollectionResult =
        getMoveCollectionResultToKotlin(getMoveCollectionPlain(argument.toJava()).await())

    /**
     * @see [getMoveCollection].
     * @param moveCollectionName The Move Collection Name.
     * @param resourceGroupName The Resource Group Name.
     * @return Define the move collection.
     */
    public suspend fun getMoveCollection(moveCollectionName: String, resourceGroupName: String):
        GetMoveCollectionResult {
        val argument = GetMoveCollectionPlainArgs(
            moveCollectionName = moveCollectionName,
            resourceGroupName = resourceGroupName,
        )
        return getMoveCollectionResultToKotlin(getMoveCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMoveCollection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetMoveCollectionPlainArgs].
     * @return Define the move collection.
     */
    public suspend
    fun getMoveCollection(argument: suspend GetMoveCollectionPlainArgsBuilder.() -> Unit):
        GetMoveCollectionResult {
        val builder = GetMoveCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMoveCollectionResultToKotlin(getMoveCollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Move Resource.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2023-08-01.
     * @param argument null
     * @return Defines the move resource.
     */
    public suspend fun getMoveResource(argument: GetMoveResourcePlainArgs): GetMoveResourceResult =
        getMoveResourceResultToKotlin(getMoveResourcePlain(argument.toJava()).await())

    /**
     * @see [getMoveResource].
     * @param moveCollectionName The Move Collection Name.
     * @param moveResourceName The Move Resource Name.
     * @param resourceGroupName The Resource Group Name.
     * @return Defines the move resource.
     */
    public suspend fun getMoveResource(
        moveCollectionName: String,
        moveResourceName: String,
        resourceGroupName: String,
    ): GetMoveResourceResult {
        val argument = GetMoveResourcePlainArgs(
            moveCollectionName = moveCollectionName,
            moveResourceName = moveResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getMoveResourceResultToKotlin(getMoveResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getMoveResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetMoveResourcePlainArgs].
     * @return Defines the move resource.
     */
    public suspend fun getMoveResource(argument: suspend GetMoveResourcePlainArgsBuilder.() -> Unit):
        GetMoveResourceResult {
        val builder = GetMoveResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMoveResourceResultToKotlin(getMoveResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get information related to a specific private endpoint connection in the project. Returns a json object of type 'privateEndpointConnections' as specified in the models section.
     * Azure REST API version: 2019-10-01.
     * @param argument null
     * @return A private endpoint connection for a project.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName Unique name of a private endpoint connection within a project.
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return A private endpoint connection for a project.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection for a project.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the private endpoint with the specified name.
     * Azure REST API version: 2020-05-01.
     * Other available API versions: 2023-01-01.
     * @param argument null
     * @return REST model used to encapsulate the user visible state of a PrivateEndpoint.
     */
    public suspend
    fun getPrivateEndpointConnectionControllerPrivateEndpointConnection(argument: GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionControllerPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionControllerPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionControllerPrivateEndpointConnection].
     * @param migrateProjectName Migrate project name.
     * @param peConnectionName Private endpoint connection name.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return REST model used to encapsulate the user visible state of a PrivateEndpoint.
     */
    public suspend fun getPrivateEndpointConnectionControllerPrivateEndpointConnection(
        migrateProjectName: String,
        peConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs(
            migrateProjectName = migrateProjectName,
            peConnectionName = peConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionControllerPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionControllerPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionControllerPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs].
     * @return REST model used to encapsulate the user visible state of a PrivateEndpoint.
     */
    public suspend
    fun getPrivateEndpointConnectionControllerPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionControllerPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionControllerPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a PrivateEndpointConnection
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return Private endpoint connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionOperation(argument: GetPrivateEndpointConnectionOperationPlainArgs):
        GetPrivateEndpointConnectionOperationResult =
        getPrivateEndpointConnectionOperationResultToKotlin(getPrivateEndpointConnectionOperationPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionOperation].
     * @param privateEndpointConnectionName Private endpoint connection ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnectionOperation(
        privateEndpointConnectionName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionOperationResult {
        val argument = GetPrivateEndpointConnectionOperationPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionOperationResultToKotlin(getPrivateEndpointConnectionOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionOperationPlainArgs].
     * @return Private endpoint connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionOperation(argument: suspend GetPrivateEndpointConnectionOperationPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionOperationResult {
        val builder = GetPrivateEndpointConnectionOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionOperationResultToKotlin(getPrivateEndpointConnectionOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the of private link proxy resources from a migrate project and private link proxy resource.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Defines Private endpoint proxy resource.
     */
    public suspend
    fun getPrivateEndpointConnectionProxyController(argument: GetPrivateEndpointConnectionProxyControllerPlainArgs):
        GetPrivateEndpointConnectionProxyControllerResult =
        getPrivateEndpointConnectionProxyControllerResultToKotlin(getPrivateEndpointConnectionProxyControllerPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionProxyController].
     * @param migrateProjectName Name of the Azure Migrate project.
     * @param pecProxyName Private link proxy name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Defines Private endpoint proxy resource.
     */
    public suspend fun getPrivateEndpointConnectionProxyController(
        migrateProjectName: String,
        pecProxyName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionProxyControllerResult {
        val argument = GetPrivateEndpointConnectionProxyControllerPlainArgs(
            migrateProjectName = migrateProjectName,
            pecProxyName = pecProxyName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionProxyControllerResultToKotlin(getPrivateEndpointConnectionProxyControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionProxyController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionProxyControllerPlainArgs].
     * @return Defines Private endpoint proxy resource.
     */
    public suspend
    fun getPrivateEndpointConnectionProxyController(argument: suspend GetPrivateEndpointConnectionProxyControllerPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionProxyControllerResult {
        val builder = GetPrivateEndpointConnectionProxyControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionProxyControllerResultToKotlin(getPrivateEndpointConnectionProxyControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the project with the specified name.
     * Azure REST API version: 2019-10-01.
     * Other available API versions: 2018-02-02.
     * @param argument null
     * @return Azure Migrate Project.
     */
    public suspend fun getProject(argument: GetProjectPlainArgs): GetProjectResult =
        getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())

    /**
     * @see [getProject].
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return Azure Migrate Project.
     */
    public suspend fun getProject(projectName: String, resourceGroupName: String): GetProjectResult {
        val argument = GetProjectPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getProject].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetProjectPlainArgs].
     * @return Azure Migrate Project.
     */
    public suspend fun getProject(argument: suspend GetProjectPlainArgsBuilder.() -> Unit):
        GetProjectResult {
        val builder = GetProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectResultToKotlin(getProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Log Analytics Workspace ID and Primary Key for the specified project.
     * Azure REST API version: 2018-02-02.
     * @param argument null
     * @return ID and Key for Migration Project.
     */
    public suspend fun getProjectKeys(argument: GetProjectKeysPlainArgs): GetProjectKeysResult =
        getProjectKeysResultToKotlin(getProjectKeysPlain(argument.toJava()).await())

    /**
     * @see [getProjectKeys].
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @return ID and Key for Migration Project.
     */
    public suspend fun getProjectKeys(projectName: String, resourceGroupName: String):
        GetProjectKeysResult {
        val argument = GetProjectKeysPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getProjectKeysResultToKotlin(getProjectKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetProjectKeysPlainArgs].
     * @return ID and Key for Migration Project.
     */
    public suspend fun getProjectKeys(argument: suspend GetProjectKeysPlainArgsBuilder.() -> Unit):
        GetProjectKeysResult {
        val builder = GetProjectKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectKeysResultToKotlin(getProjectKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Server collector.
     * Azure REST API version: 2019-10-01.
     * @param argument null
     * @return null
     */
    public suspend fun getServerCollector(argument: GetServerCollectorPlainArgs):
        GetServerCollectorResult =
        getServerCollectorResultToKotlin(getServerCollectorPlain(argument.toJava()).await())

    /**
     * @see [getServerCollector].
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @param serverCollectorName Unique name of a Server collector within a project.
     * @return null
     */
    public suspend fun getServerCollector(
        projectName: String,
        resourceGroupName: String,
        serverCollectorName: String,
    ): GetServerCollectorResult {
        val argument = GetServerCollectorPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
            serverCollectorName = serverCollectorName,
        )
        return getServerCollectorResultToKotlin(getServerCollectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerCollector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetServerCollectorPlainArgs].
     * @return null
     */
    public suspend
    fun getServerCollector(argument: suspend GetServerCollectorPlainArgsBuilder.() -> Unit):
        GetServerCollectorResult {
        val builder = GetServerCollectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerCollectorResultToKotlin(getServerCollectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ServerCollector
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return Physical server collector resource.
     */
    public suspend fun getServerCollectorsOperation(argument: GetServerCollectorsOperationPlainArgs):
        GetServerCollectorsOperationResult =
        getServerCollectorsOperationResultToKotlin(getServerCollectorsOperationPlain(argument.toJava()).await())

    /**
     * @see [getServerCollectorsOperation].
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverCollectorName Physical server collector ARM name
     * @return Physical server collector resource.
     */
    public suspend fun getServerCollectorsOperation(
        projectName: String,
        resourceGroupName: String,
        serverCollectorName: String,
    ): GetServerCollectorsOperationResult {
        val argument = GetServerCollectorsOperationPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
            serverCollectorName = serverCollectorName,
        )
        return getServerCollectorsOperationResultToKotlin(getServerCollectorsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerCollectorsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetServerCollectorsOperationPlainArgs].
     * @return Physical server collector resource.
     */
    public suspend
    fun getServerCollectorsOperation(argument: suspend GetServerCollectorsOperationPlainArgsBuilder.() -> Unit):
        GetServerCollectorsOperationResult {
        val builder = GetServerCollectorsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerCollectorsOperationResultToKotlin(getServerCollectorsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Solution REST Resource.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return Solution REST Resource.
     */
    public suspend fun getSolution(argument: GetSolutionPlainArgs): GetSolutionResult =
        getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())

    /**
     * @see [getSolution].
     * @param migrateProjectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that migrate project is part of.
     * @param solutionName Unique name of a migration solution within a migrate project.
     * @return Solution REST Resource.
     */
    public suspend fun getSolution(
        migrateProjectName: String,
        resourceGroupName: String,
        solutionName: String,
    ): GetSolutionResult {
        val argument = GetSolutionPlainArgs(
            migrateProjectName = migrateProjectName,
            resourceGroupName = resourceGroupName,
            solutionName = solutionName,
        )
        return getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolution].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetSolutionPlainArgs].
     * @return Solution REST Resource.
     */
    public suspend fun getSolution(argument: suspend GetSolutionPlainArgsBuilder.() -> Unit):
        GetSolutionResult {
        val builder = GetSolutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionResultToKotlin(getSolutionPlain(builtArgument.toJava()).await())
    }

    /**
     * Class representing the config for the solution in the migrate project.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return Class representing the config for the solution in the migrate project.
     */
    public suspend fun getSolutionConfig(argument: GetSolutionConfigPlainArgs):
        GetSolutionConfigResult =
        getSolutionConfigResultToKotlin(getSolutionConfigPlain(argument.toJava()).await())

    /**
     * @see [getSolutionConfig].
     * @param migrateProjectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that migrate project is part of.
     * @param solutionName Unique name of a migration solution within a migrate project.
     * @return Class representing the config for the solution in the migrate project.
     */
    public suspend fun getSolutionConfig(
        migrateProjectName: String,
        resourceGroupName: String,
        solutionName: String,
    ): GetSolutionConfigResult {
        val argument = GetSolutionConfigPlainArgs(
            migrateProjectName = migrateProjectName,
            resourceGroupName = resourceGroupName,
            solutionName = solutionName,
        )
        return getSolutionConfigResultToKotlin(getSolutionConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolutionConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetSolutionConfigPlainArgs].
     * @return Class representing the config for the solution in the migrate project.
     */
    public suspend
    fun getSolutionConfig(argument: suspend GetSolutionConfigPlainArgsBuilder.() -> Unit):
        GetSolutionConfigResult {
        val builder = GetSolutionConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionConfigResultToKotlin(getSolutionConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Class representing the config for the solution in the migrate project.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Class representing the config for the solution in the migrate project.
     */
    public suspend fun getSolutionsControllerConfig(argument: GetSolutionsControllerConfigPlainArgs):
        GetSolutionsControllerConfigResult =
        getSolutionsControllerConfigResultToKotlin(getSolutionsControllerConfigPlain(argument.toJava()).await())

    /**
     * @see [getSolutionsControllerConfig].
     * @param migrateProjectName Name of the Azure Migrate project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param solutionName Unique name of a migration solution within a migrate project.
     * @return Class representing the config for the solution in the migrate project.
     */
    public suspend fun getSolutionsControllerConfig(
        migrateProjectName: String,
        resourceGroupName: String,
        solutionName: String,
    ): GetSolutionsControllerConfigResult {
        val argument = GetSolutionsControllerConfigPlainArgs(
            migrateProjectName = migrateProjectName,
            resourceGroupName = resourceGroupName,
            solutionName = solutionName,
        )
        return getSolutionsControllerConfigResultToKotlin(getSolutionsControllerConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolutionsControllerConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetSolutionsControllerConfigPlainArgs].
     * @return Class representing the config for the solution in the migrate project.
     */
    public suspend
    fun getSolutionsControllerConfig(argument: suspend GetSolutionsControllerConfigPlainArgsBuilder.() -> Unit):
        GetSolutionsControllerConfigResult {
        val builder = GetSolutionsControllerConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionsControllerConfigResultToKotlin(getSolutionsControllerConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Solution REST Resource.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Solution REST Resource.
     */
    public suspend
    fun getSolutionsControllerSolution(argument: GetSolutionsControllerSolutionPlainArgs):
        GetSolutionsControllerSolutionResult =
        getSolutionsControllerSolutionResultToKotlin(getSolutionsControllerSolutionPlain(argument.toJava()).await())

    /**
     * @see [getSolutionsControllerSolution].
     * @param migrateProjectName Name of the Azure Migrate project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param solutionName Unique name of a migration solution within a migrate project.
     * @return Solution REST Resource.
     */
    public suspend fun getSolutionsControllerSolution(
        migrateProjectName: String,
        resourceGroupName: String,
        solutionName: String,
    ): GetSolutionsControllerSolutionResult {
        val argument = GetSolutionsControllerSolutionPlainArgs(
            migrateProjectName = migrateProjectName,
            resourceGroupName = resourceGroupName,
            solutionName = solutionName,
        )
        return getSolutionsControllerSolutionResultToKotlin(getSolutionsControllerSolutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolutionsControllerSolution].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetSolutionsControllerSolutionPlainArgs].
     * @return Solution REST Resource.
     */
    public suspend
    fun getSolutionsControllerSolution(argument: suspend GetSolutionsControllerSolutionPlainArgsBuilder.() -> Unit):
        GetSolutionsControllerSolutionResult {
        val builder = GetSolutionsControllerSolutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionsControllerSolutionResultToKotlin(getSolutionsControllerSolutionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SqlAssessmentV2
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return SQL Assessment REST resource.
     */
    public suspend fun getSqlAssessmentV2Operation(argument: GetSqlAssessmentV2OperationPlainArgs):
        GetSqlAssessmentV2OperationResult =
        getSqlAssessmentV2OperationResultToKotlin(getSqlAssessmentV2OperationPlain(argument.toJava()).await())

    /**
     * @see [getSqlAssessmentV2Operation].
     * @param assessmentName SQL Assessment arm name.
     * @param groupName Group ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return SQL Assessment REST resource.
     */
    public suspend fun getSqlAssessmentV2Operation(
        assessmentName: String,
        groupName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetSqlAssessmentV2OperationResult {
        val argument = GetSqlAssessmentV2OperationPlainArgs(
            assessmentName = assessmentName,
            groupName = groupName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getSqlAssessmentV2OperationResultToKotlin(getSqlAssessmentV2OperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlAssessmentV2Operation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetSqlAssessmentV2OperationPlainArgs].
     * @return SQL Assessment REST resource.
     */
    public suspend
    fun getSqlAssessmentV2Operation(argument: suspend GetSqlAssessmentV2OperationPlainArgsBuilder.() -> Unit):
        GetSqlAssessmentV2OperationResult {
        val builder = GetSqlAssessmentV2OperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlAssessmentV2OperationResultToKotlin(getSqlAssessmentV2OperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SqlCollector
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return The SQL collector REST object.
     */
    public suspend fun getSqlCollectorOperation(argument: GetSqlCollectorOperationPlainArgs):
        GetSqlCollectorOperationResult =
        getSqlCollectorOperationResultToKotlin(getSqlCollectorOperationPlain(argument.toJava()).await())

    /**
     * @see [getSqlCollectorOperation].
     * @param collectorName Sql collector ARM name.
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The SQL collector REST object.
     */
    public suspend fun getSqlCollectorOperation(
        collectorName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetSqlCollectorOperationResult {
        val argument = GetSqlCollectorOperationPlainArgs(
            collectorName = collectorName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getSqlCollectorOperationResultToKotlin(getSqlCollectorOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlCollectorOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetSqlCollectorOperationPlainArgs].
     * @return The SQL collector REST object.
     */
    public suspend
    fun getSqlCollectorOperation(argument: suspend GetSqlCollectorOperationPlainArgsBuilder.() -> Unit):
        GetSqlCollectorOperationResult {
        val builder = GetSqlCollectorOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlCollectorOperationResultToKotlin(getSqlCollectorOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a VMware collector.
     * Azure REST API version: 2019-10-01.
     * @param argument null
     * @return null
     */
    public suspend fun getVMwareCollector(argument: GetVMwareCollectorPlainArgs):
        GetVMwareCollectorResult =
        getVMwareCollectorResultToKotlin(getVMwareCollectorPlain(argument.toJava()).await())

    /**
     * @see [getVMwareCollector].
     * @param projectName Name of the Azure Migrate project.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @param vmWareCollectorName Unique name of a VMware collector within a project.
     * @return null
     */
    public suspend fun getVMwareCollector(
        projectName: String,
        resourceGroupName: String,
        vmWareCollectorName: String,
    ): GetVMwareCollectorResult {
        val argument = GetVMwareCollectorPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
            vmWareCollectorName = vmWareCollectorName,
        )
        return getVMwareCollectorResultToKotlin(getVMwareCollectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getVMwareCollector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetVMwareCollectorPlainArgs].
     * @return null
     */
    public suspend
    fun getVMwareCollector(argument: suspend GetVMwareCollectorPlainArgsBuilder.() -> Unit):
        GetVMwareCollectorResult {
        val builder = GetVMwareCollectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVMwareCollectorResultToKotlin(getVMwareCollectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a VmwareCollector
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2023-04-01-preview.
     * @param argument null
     * @return VMware collector resource.
     */
    public suspend fun getVmwareCollectorsOperation(argument: GetVmwareCollectorsOperationPlainArgs):
        GetVmwareCollectorsOperationResult =
        getVmwareCollectorsOperationResultToKotlin(getVmwareCollectorsOperationPlain(argument.toJava()).await())

    /**
     * @see [getVmwareCollectorsOperation].
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmWareCollectorName VMware collector ARM name
     * @return VMware collector resource.
     */
    public suspend fun getVmwareCollectorsOperation(
        projectName: String,
        resourceGroupName: String,
        vmWareCollectorName: String,
    ): GetVmwareCollectorsOperationResult {
        val argument = GetVmwareCollectorsOperationPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
            vmWareCollectorName = vmWareCollectorName,
        )
        return getVmwareCollectorsOperationResultToKotlin(getVmwareCollectorsOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getVmwareCollectorsOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetVmwareCollectorsOperationPlainArgs].
     * @return VMware collector resource.
     */
    public suspend
    fun getVmwareCollectorsOperation(argument: suspend GetVmwareCollectorsOperationPlainArgsBuilder.() -> Unit):
        GetVmwareCollectorsOperationResult {
        val builder = GetVmwareCollectorsOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVmwareCollectorsOperationResultToKotlin(getVmwareCollectorsOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a WebAppAssessmentV2
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return Web app Assessment REST resource.
     */
    public suspend
    fun getWebAppAssessmentV2Operation(argument: GetWebAppAssessmentV2OperationPlainArgs):
        GetWebAppAssessmentV2OperationResult =
        getWebAppAssessmentV2OperationResultToKotlin(getWebAppAssessmentV2OperationPlain(argument.toJava()).await())

    /**
     * @see [getWebAppAssessmentV2Operation].
     * @param assessmentName Web app Assessment arm name.
     * @param groupName Group ARM name
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Web app Assessment REST resource.
     */
    public suspend fun getWebAppAssessmentV2Operation(
        assessmentName: String,
        groupName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetWebAppAssessmentV2OperationResult {
        val argument = GetWebAppAssessmentV2OperationPlainArgs(
            assessmentName = assessmentName,
            groupName = groupName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getWebAppAssessmentV2OperationResultToKotlin(getWebAppAssessmentV2OperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebAppAssessmentV2Operation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetWebAppAssessmentV2OperationPlainArgs].
     * @return Web app Assessment REST resource.
     */
    public suspend
    fun getWebAppAssessmentV2Operation(argument: suspend GetWebAppAssessmentV2OperationPlainArgsBuilder.() -> Unit):
        GetWebAppAssessmentV2OperationResult {
        val builder = GetWebAppAssessmentV2OperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebAppAssessmentV2OperationResultToKotlin(getWebAppAssessmentV2OperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a WebAppCollector
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return The web app collector REST object.
     */
    public suspend fun getWebAppCollectorOperation(argument: GetWebAppCollectorOperationPlainArgs):
        GetWebAppCollectorOperationResult =
        getWebAppCollectorOperationResultToKotlin(getWebAppCollectorOperationPlain(argument.toJava()).await())

    /**
     * @see [getWebAppCollectorOperation].
     * @param collectorName Web app collector ARM name.
     * @param projectName Assessment Project Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The web app collector REST object.
     */
    public suspend fun getWebAppCollectorOperation(
        collectorName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetWebAppCollectorOperationResult {
        val argument = GetWebAppCollectorOperationPlainArgs(
            collectorName = collectorName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getWebAppCollectorOperationResultToKotlin(getWebAppCollectorOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebAppCollectorOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetWebAppCollectorOperationPlainArgs].
     * @return The web app collector REST object.
     */
    public suspend
    fun getWebAppCollectorOperation(argument: suspend GetWebAppCollectorOperationPlainArgsBuilder.() -> Unit):
        GetWebAppCollectorOperationResult {
        val builder = GetWebAppCollectorOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebAppCollectorOperationResultToKotlin(getWebAppCollectorOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the workload deployment.
     * Azure REST API version: 2022-05-01-preview.
     * @param argument null
     * @return Workload deployment model.
     */
    public suspend fun getWorkloadDeployment(argument: GetWorkloadDeploymentPlainArgs):
        GetWorkloadDeploymentResult =
        getWorkloadDeploymentResultToKotlin(getWorkloadDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadDeployment].
     * @param modernizeProjectName ModernizeProject name.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @param subscriptionId Azure Subscription Id in which project was created.
     * @param workloadDeploymentName Workload deployment name.
     * @return Workload deployment model.
     */
    public suspend fun getWorkloadDeployment(
        modernizeProjectName: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
        workloadDeploymentName: String,
    ): GetWorkloadDeploymentResult {
        val argument = GetWorkloadDeploymentPlainArgs(
            modernizeProjectName = modernizeProjectName,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
            workloadDeploymentName = workloadDeploymentName,
        )
        return getWorkloadDeploymentResultToKotlin(getWorkloadDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetWorkloadDeploymentPlainArgs].
     * @return Workload deployment model.
     */
    public suspend
    fun getWorkloadDeployment(argument: suspend GetWorkloadDeploymentPlainArgsBuilder.() -> Unit):
        GetWorkloadDeploymentResult {
        val builder = GetWorkloadDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadDeploymentResultToKotlin(getWorkloadDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the secrets of the workload deployment.
     * Azure REST API version: 2022-05-01-preview.
     * @param argument null
     * @return Workload deployment model.
     */
    public suspend
    fun getWorkloadDeploymentSecretConfigurations(argument: GetWorkloadDeploymentSecretConfigurationsPlainArgs):
        GetWorkloadDeploymentSecretConfigurationsResult =
        getWorkloadDeploymentSecretConfigurationsResultToKotlin(getWorkloadDeploymentSecretConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadDeploymentSecretConfigurations].
     * @param modernizeProjectName ModernizeProject name.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @param subscriptionId Azure Subscription Id in which project was created.
     * @param workloadDeploymentName Workload deployment name.
     * @return Workload deployment model.
     */
    public suspend fun getWorkloadDeploymentSecretConfigurations(
        modernizeProjectName: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
        workloadDeploymentName: String,
    ): GetWorkloadDeploymentSecretConfigurationsResult {
        val argument = GetWorkloadDeploymentSecretConfigurationsPlainArgs(
            modernizeProjectName = modernizeProjectName,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
            workloadDeploymentName = workloadDeploymentName,
        )
        return getWorkloadDeploymentSecretConfigurationsResultToKotlin(getWorkloadDeploymentSecretConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadDeploymentSecretConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetWorkloadDeploymentSecretConfigurationsPlainArgs].
     * @return Workload deployment model.
     */
    public suspend
    fun getWorkloadDeploymentSecretConfigurations(argument: suspend GetWorkloadDeploymentSecretConfigurationsPlainArgsBuilder.() -> Unit):
        GetWorkloadDeploymentSecretConfigurationsResult {
        val builder = GetWorkloadDeploymentSecretConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadDeploymentSecretConfigurationsResultToKotlin(getWorkloadDeploymentSecretConfigurationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the workload instance.
     * Azure REST API version: 2022-05-01-preview.
     * @param argument null
     * @return Workload instance model.
     */
    public suspend fun getWorkloadInstance(argument: GetWorkloadInstancePlainArgs):
        GetWorkloadInstanceResult =
        getWorkloadInstanceResultToKotlin(getWorkloadInstancePlain(argument.toJava()).await())

    /**
     * @see [getWorkloadInstance].
     * @param modernizeProjectName ModernizeProject name.
     * @param resourceGroupName Name of the Azure Resource Group that project is part of.
     * @param subscriptionId Azure Subscription Id in which project was created.
     * @param workloadInstanceName Workload instance name.
     * @return Workload instance model.
     */
    public suspend fun getWorkloadInstance(
        modernizeProjectName: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
        workloadInstanceName: String,
    ): GetWorkloadInstanceResult {
        val argument = GetWorkloadInstancePlainArgs(
            modernizeProjectName = modernizeProjectName,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
            workloadInstanceName = workloadInstanceName,
        )
        return getWorkloadInstanceResultToKotlin(getWorkloadInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;migrate&#46;kotlin&#46;inputs&#46;GetWorkloadInstancePlainArgs].
     * @return Workload instance model.
     */
    public suspend
    fun getWorkloadInstance(argument: suspend GetWorkloadInstancePlainArgsBuilder.() -> Unit):
        GetWorkloadInstanceResult {
        val builder = GetWorkloadInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadInstanceResultToKotlin(getWorkloadInstancePlain(builtArgument.toJava()).await())
    }
}
